/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.CheckValidXmlInScriptBodyInspectionBase;
import org.jetbrains.annotations.NotNull;

public class CheckValidXmlInScriptBodyInspection
extends CheckValidXmlInScriptBodyInspectionBase {
    protected InsertQuotedCharacterQuickFix createFix(PsiElement psiElement, int offsetInElement) {
        return new InsertQuotedCharacterQuickFix(psiElement, offsetInElement);
    }

    private static class InsertQuotedCharacterQuickFix
    extends LocalQuickFixOnPsiElement {
        private final int startInElement;

        InsertQuotedCharacterQuickFix(PsiElement psiElement, int startInElement) {
            super(psiElement);
            this.startInElement = startInElement;
        }

        @NotNull
        public String getText() {
            String character = this.getXmlCharacter();
            String string = character.equals("&") ? XmlBundle.message((String)"xml.quickfix.unescaped.xml.character.ampersand", (Object[])new Object[0]) : XmlBundle.message((String)"xml.quickfix.unescaped.xml.character.text", (Object[])new Object[]{character});
            if (string == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlBundle.message((String)"xml.quickfix.unescaped.xml.character.family", (Object[])new Object[0]);
            if (string == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(5);
            }
            PsiFile psiFile = startElement.getContainingFile();
            TextRange range = startElement.getTextRange();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, psiFile.getVirtualFile(), range.getStartOffset() + this.startInElement);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
            if (editor == null) {
                return;
            }
            String xmlCharacter = this.getXmlCharacter();
            String replacement = xmlCharacter.equals("&") ? "&amp;" : "&lt;";
            replacement = startElement.getText().replace(xmlCharacter, replacement);
            InjectedLanguageUtil.getTopLevelEditor((Editor)editor).getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacement);
        }

        private String getXmlCharacter() {
            return this.getStartElement().getText().substring(this.startInElement, this.startInElement + 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

