/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.openapi.util.JDOMUtil;
import java.io.Closeable;
import java.io.Reader;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.batik.anim.dom.SVG12DOMImplementation;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericText;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.util.ParsedURL;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\bH\u0007\u001a\u001a\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u001a(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0018"}, d2={"buildDocument", "Lorg/apache/batik/anim/dom/SVGOMDocument;", "reader", "Ljavax/xml/stream/XMLStreamReader;", "createSvgDocument", "Lorg/w3c/dom/Document;", "uri", "", "Ljava/io/Reader;", "getRawName", "prefix", "localName", "isAllXMLWhitespace", "", "value", "processElementFragment", "", "document", "factory", "Lorg/apache/batik/anim/dom/SVGDOMImplementation;", "parent", "Lorg/w3c/dom/Element;", "readAttributes", "element", "intellij.platform.util.ui"})
public final class SvgDocumentFactoryKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static final Document createSvgDocument(@Nullable String uri, @NotNull Reader reader) {
        SVGOMDocument sVGOMDocument;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Closeable closeable = reader;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            SVGOMDocument sVGOMDocument2;
            Reader it = (Reader)closeable;
            boolean bl3 = false;
            try (XMLStreamReader xmlStreamReader = JDOMUtil.getXmlInputFactory().createXMLStreamReader(reader);){
                XMLStreamReader xMLStreamReader = xmlStreamReader;
                Intrinsics.checkNotNullExpressionValue((Object)xMLStreamReader, (String)"xmlStreamReader");
                sVGOMDocument2 = SvgDocumentFactoryKt.buildDocument(xMLStreamReader);
            }
            sVGOMDocument = sVGOMDocument2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        SVGOMDocument result = sVGOMDocument;
        if (uri != null) {
            result.setParsedURL(new ParsedURL(uri));
            result.setDocumentURI(uri);
        }
        return (Document)result;
    }

    /*
     * Unable to fully structure code
     */
    private static final SVGOMDocument buildDocument(XMLStreamReader reader) {
        state = reader.getEventType();
        if (7 != state) {
            throw (Throwable)new TranscoderException("Incorrect state: " + state);
        }
        document = null;
        while (state != 8) {
            switch (state) {
                case 7: {
                    var3_3 = document == null;
                    var4_6 = 0;
                    var5_8 = 0;
                    if (!_Assertions.ENABLED || var3_3) break;
                    var6_12 = false;
                    var6_13 = "Assertion failed";
                    throw (Throwable)new AssertionError((Object)var6_13);
                }
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    break;
                }
                case 1: {
                    version = null;
                    var4_6 = 0;
                    var5_8 = reader.getAttributeCount();
                    while (var4_6 < var5_8) {
                        localName = reader.getAttributeLocalName((int)i);
                        v0 = prefix = reader.getAttributePrefix((int)i);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"prefix");
                        var8_16 = v0;
                        var9_17 = false;
                        if (var8_16.length() == 0 && Intrinsics.areEqual((Object)localName, (Object)"version")) {
                            version = reader.getAttributeValue((int)i);
                            break;
                        }
                        ++i;
                    }
                    if (version == null) ** GOTO lbl-1000
                    var5_9 = version;
                    localName = false;
                    if (var5_9.length() == 0 || Intrinsics.areEqual((Object)version, (Object)"1.0") || Intrinsics.areEqual((Object)version, (Object)"1.1")) lbl-1000:
                    // 2 sources

                    {
                        v1 = SVGDOMImplementation.getDOMImplementation();
                        if (v1 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.apache.batik.anim.dom.SVGDOMImplementation");
                        }
                        v2 = (SVGDOMImplementation)v1;
                    } else if (Intrinsics.areEqual((Object)version, (Object)"1.2")) {
                        v3 = SVG12DOMImplementation.getDOMImplementation();
                        if (v3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.apache.batik.anim.dom.SVGDOMImplementation");
                        }
                        v2 = (SVGDOMImplementation)v3;
                    } else {
                        throw (Throwable)new TranscoderException("Unsupported SVG version: " + version);
                    }
                    implementation = v2;
                    localName = reader.getLocalName();
                    v4 = reader.getNamespaceURI();
                    v5 = reader.getPrefix();
                    v6 = localName;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"localName");
                    v7 = implementation.createDocument(v4, SvgDocumentFactoryKt.getRawName(v5, v6), null);
                    if (v7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.apache.batik.anim.dom.SVGOMDocument");
                    }
                    document = (SVGOMDocument)v7;
                    v8 = element = document.getDocumentElement();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"element");
                    SvgDocumentFactoryKt.readAttributes(v8, reader);
                    if (Intrinsics.areEqual((Object)localName, (Object)"svg") ^ true) {
                        throw (Throwable)new TranscoderException("Root element does not match that requested:\nRequested: svg\nFound: " + localName);
                    }
                    SvgDocumentFactoryKt.processElementFragment(reader, document, implementation, element);
                    break;
                }
                case 4: {
                    v9 = badContent = reader.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"badContent");
                    if (SvgDocumentFactoryKt.isAllXMLWhitespace(v9)) break;
                    throw (Throwable)new TranscoderException("Unexpected XMLStream event at Document level: CHARACTERS (" + badContent + ')');
                }
                default: {
                    throw (Throwable)new TranscoderException("Unexpected XMLStream event at Document level:" + state);
                }
            }
            if (!reader.hasNext()) {
                throw (Throwable)new TranscoderException("Unexpected end-of-XMLStreamReader");
            }
            state = reader.next();
        }
        v10 = document;
        Intrinsics.checkNotNull((Object)v10);
        return v10;
    }

    private static final void processElementFragment(XMLStreamReader reader, SVGOMDocument document, SVGDOMImplementation factory, Element parent) {
        int depth = 1;
        Node current = parent;
        block7: while (depth > 0 && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    Element element;
                    Element element2 = element = factory.createElementNS((AbstractDocument)document, reader.getNamespaceURI(), reader.getLocalName());
                    Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element");
                    SvgDocumentFactoryKt.readAttributes(element2, reader);
                    current.appendChild(element);
                    current = element;
                    ++depth;
                    continue block7;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue((Object)current.getParentNode(), (String)"current.parentNode");
                    --depth;
                    continue block7;
                }
                case 12: {
                    current.appendChild((Node)new GenericCDATASection(reader.getText(), (AbstractDocument)document));
                    continue block7;
                }
                case 4: 
                case 6: {
                    if (reader.isWhiteSpace()) continue block7;
                    current.appendChild((Node)new GenericText(reader.getText(), (AbstractDocument)document));
                    continue block7;
                }
                case 3: 
                case 5: 
                case 9: {
                    continue block7;
                }
            }
            throw (Throwable)new TranscoderException("Unexpected XMLStream event: " + reader.getEventType());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void readAttributes(Element element, XMLStreamReader reader) {
        int n = 0;
        int n2 = reader.getAttributeCount();
        while (n < n2) {
            void i;
            String localName = reader.getAttributeLocalName((int)i);
            String prefix = reader.getAttributePrefix((int)i);
            String string = reader.getAttributeNamespace((int)i);
            String string2 = localName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"localName");
            element.setAttributeNS(string, SvgDocumentFactoryKt.getRawName(prefix, string2), reader.getAttributeValue((int)i));
            ++i;
        }
    }

    private static final String getRawName(String prefix, String localName) {
        CharSequence charSequence = prefix;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || charSequence.length() == 0 ? localName : prefix + ':' + localName;
    }

    private static final boolean isAllXMLWhitespace(String value) {
        int i = value.length();
        while (--i >= 0) {
            char c = value.charAt(i);
            if (c == ' ' || c == '\n' || c == '\t' || c == '\r') continue;
            return false;
        }
        return true;
    }
}

