/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceRootDescriptor;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTargetType;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public final class MavenResourcesTarget
extends ModuleBasedTarget<MavenResourceRootDescriptor> {
    MavenResourcesTarget(MavenResourcesTargetType type, @NotNull JpsModule module) {
        if (module == null) {
            MavenResourcesTarget.$$$reportNull$$$0(0);
        }
        super((ModuleBasedBuildTargetType)type, module);
    }

    public String getId() {
        return this.myModule.getName();
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        return Collections.emptyList();
    }

    public boolean isCompiledBeforeModuleLevelBuilders() {
        return true;
    }

    @NotNull
    public List<MavenResourceRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ArrayList<MavenResourceRootDescriptor> result = new ArrayList<MavenResourceRootDescriptor>();
        MavenModuleResourceConfiguration moduleConfig = this.getModuleResourcesConfiguration(dataPaths);
        if (moduleConfig == null) {
            List<MavenResourceRootDescriptor> list = Collections.emptyList();
            if (list == null) {
                MavenResourcesTarget.$$$reportNull$$$0(1);
            }
            return list;
        }
        int i = 0;
        for (ResourceRootConfiguration resource : this.getRootConfigurations(moduleConfig)) {
            result.add(new MavenResourceRootDescriptor(this, resource, i++, moduleConfig.overwrite));
        }
        ArrayList<MavenResourceRootDescriptor> arrayList = result;
        if (arrayList == null) {
            MavenResourcesTarget.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private Collection<ResourceRootConfiguration> getRootConfigurations(@Nullable MavenModuleResourceConfiguration moduleConfig) {
        if (moduleConfig != null) {
            return this.isTests() ? moduleConfig.testResources : moduleConfig.resources;
        }
        return Collections.emptyList();
    }

    @Nullable
    public MavenModuleResourceConfiguration getModuleResourcesConfiguration(BuildDataPaths dataPaths) {
        MavenProjectConfiguration projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        if (projectConfig == null) {
            return null;
        }
        return projectConfig.moduleConfigurations.get(this.myModule.getName());
    }

    public boolean isTests() {
        return ((MavenResourcesTargetType)this.getTargetType()).isTests();
    }

    @Nullable
    public MavenResourceRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (MavenResourceRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.getTargetType().getTypeId() + ":" + this.myModule.getName();
        if (string == null) {
            MavenResourcesTarget.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        MavenModuleResourceConfiguration configuration = this.getModuleResourcesConfiguration(context.getProjectDescriptor().dataManager.getDataPaths());
        if (configuration == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                MavenResourcesTarget.$$$reportNull$$$0(4);
            }
            return list;
        }
        Set result = FileCollectionFactory.createCanonicalFileSet();
        File moduleOutput = this.getModuleOutputDir();
        for (ResourceRootConfiguration resConfig : this.getRootConfigurations(configuration)) {
            File output = MavenResourcesTarget.getOutputDir(moduleOutput, resConfig, configuration.outputDirectory);
            if (output == null) continue;
            result.add(output);
        }
        Set set = result;
        if (set == null) {
            MavenResourcesTarget.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public File getModuleOutputDir() {
        return JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, this.isTests());
    }

    @Nullable
    public static File getOutputDir(@Nullable File moduleOutput, ResourceRootConfiguration config, @Nullable String outputDirectory) {
        if (outputDirectory != null) {
            moduleOutput = JpsPathUtil.urlToFile((String)outputDirectory);
        }
        if (moduleOutput == null) {
            return null;
        }
        String targetPath = config.targetPath;
        if (StringUtil.isEmptyOrSpaces((String)targetPath)) {
            return moduleOutput;
        }
        File targetPathFile = new File(targetPath);
        File outputFile = targetPathFile.isAbsolute() ? targetPathFile : new File(moduleOutput, targetPath);
        return new File(FileUtil.toCanonicalPath((String)outputFile.getPath()));
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        BuildDataPaths dataPaths = pd.getTargetsState().getDataPaths();
        MavenModuleResourceConfiguration configuration = this.getModuleResourcesConfiguration(dataPaths);
        if (configuration != null) {
            out.write(Integer.toHexString(configuration.computeConfigurationHash(this.isTests())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/maven/model/impl/MavenResourcesTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/maven/model/impl/MavenResourcesTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

