/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.relativizer;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Arrays;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.relativizer.CommonPathRelativizer;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;

class MavenPathRelativizer
extends CommonPathRelativizer {
    private static final String IDENTIFIER = "$MAVEN_REPOSITORY$";
    private static final String M2_DIR = ".m2";
    private static final String CONF_DIR = "conf";
    private static final String SETTINGS_XML = "settings.xml";
    private static final String REPOSITORY_PATH = "repository";
    private static final Namespace SETTINGS_NAMESPACE = Namespace.getNamespace((String)"http://maven.apache.org/SETTINGS/1.0.0");

    MavenPathRelativizer() {
        super(MavenPathRelativizer.initializeMavenRepositoryPath(), IDENTIFIER);
    }

    @Nullable
    private static String initializeMavenRepositoryPath() {
        String fromGlobalSettings;
        String fromUserSettings;
        String defaultMavenFolder = SystemProperties.getUserHome() + File.separator + M2_DIR;
        File userSettingsFile = new File(defaultMavenFolder, SETTINGS_XML);
        if (userSettingsFile.exists() && StringUtil.isNotEmpty((String)(fromUserSettings = MavenPathRelativizer.getRepositoryFromSettings(userSettingsFile))) && new File(fromUserSettings).exists()) {
            return PathRelativizerService.normalizePath(fromUserSettings);
        }
        File globalSettingsFile = new File(MavenPathRelativizer.resolveMavenHomeDirectory() + File.separator + CONF_DIR, SETTINGS_XML);
        if (globalSettingsFile.exists() && StringUtil.isNotEmpty((String)(fromGlobalSettings = MavenPathRelativizer.getRepositoryFromSettings(globalSettingsFile))) && new File(fromGlobalSettings).exists()) {
            return PathRelativizerService.normalizePath(fromGlobalSettings);
        }
        String defaultMavenRepository = defaultMavenFolder + File.separator + REPOSITORY_PATH;
        if (FileUtil.exists((String)defaultMavenFolder)) {
            return PathRelativizerService.normalizePath(defaultMavenRepository);
        }
        return null;
    }

    @Nullable
    private static String getRepositoryFromSettings(File file) {
        try {
            Element repository = JDOMUtil.load((File)file).getChild("localRepository", SETTINGS_NAMESPACE);
            if (repository == null) {
                return null;
            }
            String text = repository.getText();
            if (StringUtil.isEmpty((String)text)) {
                return null;
            }
            return text;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static String resolveMavenHomeDirectory() {
        String defaultHome;
        String mavenFromBrew;
        String m2home = System.getenv("M2_HOME");
        if (MavenPathRelativizer.isValidMavenHome(m2home)) {
            return m2home;
        }
        String mavenHome = System.getenv("MAVEN_HOME");
        if (MavenPathRelativizer.isValidMavenHome(mavenHome)) {
            return mavenHome;
        }
        String m2UserHome = SystemProperties.getUserHome() + File.separator + M2_DIR;
        if (MavenPathRelativizer.isValidMavenHome(m2UserHome)) {
            return m2UserHome;
        }
        if (SystemInfoRt.isMac && MavenPathRelativizer.isValidMavenHome(mavenFromBrew = MavenPathRelativizer.fromBrew())) {
            return mavenFromBrew;
        }
        if ((SystemInfoRt.isLinux || SystemInfoRt.isMac) && MavenPathRelativizer.isValidMavenHome(defaultHome = "/usr/share/maven")) {
            return defaultHome;
        }
        return null;
    }

    @Nullable
    private static String fromBrew() {
        File brewDir = new File("/usr/local/Cellar/maven");
        String[] list = brewDir.list();
        if (list == null || list.length == 0) {
            return null;
        }
        Arrays.sort(list, (o1, o2) -> StringUtil.compareVersionNumbers((String)o2, (String)o1));
        return brewDir + File.separator + list[0] + "/libexec";
    }

    private static boolean isValidMavenHome(@Nullable String path) {
        return StringUtil.isNotEmpty((String)path) && FileUtil.exists((String)path);
    }
}

