/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreatorBase;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderImpl;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.ExplodedDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.PackIntoArchiveInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.SkipAllInstructionCreator;

public class CopyToDirectoryInstructionCreator
extends ArtifactCompilerInstructionCreatorBase {
    private final String myOutputPath;

    public CopyToDirectoryInstructionCreator(ArtifactInstructionsBuilderImpl builder, String outputPath) {
        super(builder);
        this.myOutputPath = outputPath;
    }

    @Override
    protected DestinationInfo createFileDestination(@NotNull String outputFileName) {
        if (outputFileName == null) {
            CopyToDirectoryInstructionCreator.$$$reportNull$$$0(0);
        }
        return new ExplodedDestinationInfo(this.myOutputPath + "/" + outputFileName);
    }

    @Override
    protected ExplodedDestinationInfo createDirectoryDestination() {
        return new ExplodedDestinationInfo(this.myOutputPath);
    }

    @Override
    protected void onAdded(ArtifactRootDescriptor descriptor) {
    }

    @Override
    public CopyToDirectoryInstructionCreator subFolder(@NotNull String directoryName) {
        if (directoryName == null) {
            CopyToDirectoryInstructionCreator.$$$reportNull$$$0(1);
        }
        return new CopyToDirectoryInstructionCreator(this.myInstructionsBuilder, this.myOutputPath + "/" + directoryName);
    }

    @Override
    public ArtifactCompilerInstructionCreator archive(@NotNull String archiveFileName) {
        String jarOutputPath;
        ExplodedDestinationInfo destination;
        JarInfo jarInfo;
        if (archiveFileName == null) {
            CopyToDirectoryInstructionCreator.$$$reportNull$$$0(2);
        }
        if (!this.myInstructionsBuilder.registerJarFile(jarInfo = new JarInfo(destination = new ExplodedDestinationInfo(jarOutputPath = this.myOutputPath + "/" + archiveFileName)), jarOutputPath)) {
            return new SkipAllInstructionCreator(this.myInstructionsBuilder);
        }
        return new PackIntoArchiveInstructionCreator(this.myInstructionsBuilder, jarInfo, "", destination);
    }

    @Override
    @Nullable
    public File getTargetDirectory() {
        return new File(this.myOutputPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveFileName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/instructions/CopyToDirectoryInstructionCreator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileDestination";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "subFolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "archive";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

