/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ParameterizedRunnable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cmdline.JpsModelLoader;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;

public final class JpsModelLoaderImpl
implements JpsModelLoader {
    private static final Logger LOG = Logger.getInstance(JpsModelLoaderImpl.class);
    private final String myProjectPath;
    private final String myGlobalOptionsPath;
    private final boolean myLoadUnloadedModules;
    private final ParameterizedRunnable<? super JpsModel> myModelInitializer;

    public JpsModelLoaderImpl(String projectPath, String globalOptionsPath, boolean loadUnloadedModules, @Nullable ParameterizedRunnable<? super JpsModel> initializer) {
        this.myProjectPath = projectPath;
        this.myGlobalOptionsPath = globalOptionsPath;
        this.myLoadUnloadedModules = loadUnloadedModules;
        this.myModelInitializer = initializer;
    }

    @Override
    public JpsModel loadModel() throws IOException {
        long start = System.nanoTime();
        LOG.info("Loading model: project path = " + this.myProjectPath + ", global options path = " + this.myGlobalOptionsPath);
        JpsModel model = JpsSerializationManager.getInstance().loadModel(this.myProjectPath, this.myGlobalOptionsPath, this.myLoadUnloadedModules);
        if (this.myModelInitializer != null) {
            this.myModelInitializer.run((Object)model);
        }
        long loadTime = System.nanoTime() - start;
        LOG.info("Model loaded in " + TimeUnit.NANOSECONDS.toMillis(loadTime) + " ms");
        LOG.info("Project has " + model.getProject().getModules().size() + " modules, " + model.getProject().getLibraryCollection().getLibraries().size() + " libraries");
        return model;
    }
}

