/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.log.GitExternalLogTabsProperties;
import git4idea.log.GitShowExternalLogActionKt;
import git4idea.log.MyContentComponent;
import git4idea.repo.GitRepositoryImpl;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\u001a\u0016\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0003\u001a.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0002\u001a.\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"EXTERNAL", "", "calcLogId", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "calcTabName", "cm", "Lcom/intellij/ui/content/ContentManager;", "createManagerAndContent", "Lgit4idea/log/MyContentComponent;", "project", "Lcom/intellij/openapi/project/Project;", "vcs", "Lgit4idea/GitVcs;", "isToolWindowTab", "", "doOnProviderRemoval", "", "disposable", "Lcom/intellij/openapi/Disposable;", "closeTab", "Lkotlin/Function0;", "getGitRootsFromUser", "selectAlreadyOpened", "", "selectProjectLog", "requestedRoots", "intellij.vcs.git"})
public final class GitShowExternalLogActionKt {
    private static final String EXTERNAL = "EXTERNAL";

    /*
     * WARNING - void declaration
     */
    private static final MyContentComponent createManagerAndContent(Project project, GitVcs vcs, List<? extends VirtualFile> roots, boolean isToolWindowTab) {
        Collection<VcsRoot> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable()");
        Disposable disposable2 = disposable;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        for (VirtualFile virtualFile : roots) {
            repositoryManager.addExternalRepository(virtualFile, GitRepositoryImpl.createInstance(virtualFile, project, disposable2, true));
        }
        Iterable iterable = roots;
        VcsLogTabsProperties vcsLogTabsProperties = (VcsLogTabsProperties)ApplicationManager.getApplication().getService(GitExternalLogTabsProperties.class);
        Project project2 = project;
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            VcsRoot vcsRoot = new VcsRoot((AbstractVcs)vcs, (VirtualFile)it);
            collection.add(vcsRoot);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        VcsLogTabsProperties vcsLogTabsProperties2 = vcsLogTabsProperties;
        Project project3 = project2;
        VcsLogManager vcsLogManager = new VcsLogManager(project3, vcsLogTabsProperties2, collection2);
        Disposer.register((Disposable)disposable2, (Disposable)new Disposable(vcsLogManager, roots, repositoryManager){
            final /* synthetic */ VcsLogManager $manager;
            final /* synthetic */ List $roots;
            final /* synthetic */ GitRepositoryManager $repositoryManager;

            public final void dispose() {
                this.$manager.dispose(new Runnable(this){
                    final /* synthetic */ createManagerAndContent.1 this$0;

                    public final void run() {
                        Iterable $this$forEach$iv = this.this$0.$roots;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            VirtualFile it = (VirtualFile)element$iv;
                            boolean bl = false;
                            this.this$0.$repositoryManager.removeExternalRepository(it);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$manager = vcsLogManager;
                this.$roots = list2;
                this.$repositoryManager = gitRepositoryManager;
            }
        });
        MainVcsLogUi mainVcsLogUi = vcsLogManager.createLogUi(GitShowExternalLogActionKt.calcLogId(roots), isToolWindowTab ? VcsLogManager.LogWindowKind.TOOL_WINDOW : VcsLogManager.LogWindowKind.STANDALONE);
        Intrinsics.checkNotNullExpressionValue((Object)mainVcsLogUi, (String)"manager.createLogUi(calc\u2026LogWindowKind.STANDALONE)");
        MainVcsLogUi ui = mainVcsLogUi;
        Disposer.register((Disposable)disposable2, (Disposable)((Disposable)ui));
        return new MyContentComponent((JComponent)new VcsLogPanel(vcsLogManager, (VcsLogUiEx)ui), (Collection<? extends VirtualFile>)roots, disposable2);
    }

    private static final String calcLogId(List<? extends VirtualFile> roots) {
        StringBuilder stringBuilder = new StringBuilder().append("EXTERNAL ");
        Iterable iterable = roots;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File.pathSeparator");
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)calcLogId.1.INSTANCE, (int)30, null)).toString();
    }

    @Nls
    private static final String calcTabName(ContentManager cm, List<? extends VirtualFile> roots) {
        String name;
        String candidate = name = VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]) + " (" + ((VirtualFile)CollectionsKt.first(roots)).getName() + (roots.size() > 1 ? "+" : "") + ")";
        int cnt = 1;
        while (true) {
            boolean bl;
            block2: {
                Content[] $this$any$iv;
                Intrinsics.checkNotNullExpressionValue((Object)cm.getContents(), (String)"cm.contents");
                boolean $i$f$any = false;
                Content[] contentArray = $this$any$iv;
                int n = contentArray.length;
                for (int j = 0; j < n; ++j) {
                    Content element$iv;
                    Content content2 = element$iv = contentArray[j];
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)content2.getDisplayName(), (Object)candidate)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) break;
            candidate = name + '-' + cnt;
            ++cnt;
        }
        return candidate;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<VirtualFile> getGitRootsFromUser(Project project) {
        void $this$filterTo$iv$iv;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, true, false, true);
        VirtualFile[] virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFiles, (String)"virtualFiles");
        VirtualFile[] $this$filter$iv = virtualFiles;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var8_8 = $this$filterTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var8_8[j];
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
            if (!GitUtil.isGitRoot(new File(v0.getPath()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean selectProjectLog(Project project, GitVcs vcs, ContentManager cm, List<? extends VirtualFile> requestedRoots) {
        VirtualFile[] virtualFileArray = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"ProjectLevelVcsManager.g\u2026ct).getRootsUnderVcs(vcs)");
        List projectRoots = CollectionsKt.listOf((Object[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        if (!projectRoots.containsAll((Collection)requestedRoots)) {
            return false;
        }
        if (requestedRoots.containsAll(projectRoots)) {
            return VcsLogContentUtil.selectMainLog((ContentManager)cm);
        }
        VcsLogFilterCollection filters = VcsLogFilterObject.collection((VcsLogFilter[])new VcsLogFilter[]{(VcsLogFilter)VcsLogFilterObject.fromRoots((Collection)requestedRoots)});
        return VcsProjectLog.getInstance((Project)project).openLogTab(filters) != null;
    }

    private static final boolean selectAlreadyOpened(ContentManager cm, Collection<? extends VirtualFile> roots) {
        Content content2;
        block2: {
            Content[] contentArray = cm.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"cm.contents");
            Content[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            Content[] contentArray2 = $this$firstOrNull$iv;
            int n = contentArray2.length;
            for (int j = 0; j < n; ++j) {
                JComponent component;
                Content element$iv;
                Content content3 = element$iv = contentArray2[j];
                boolean bl = false;
                Content content4 = content3;
                Intrinsics.checkNotNullExpressionValue((Object)content4, (String)"content");
                Intrinsics.checkNotNullExpressionValue((Object)content4.getComponent(), (String)"content.component");
                boolean bl2 = component instanceof MyContentComponent ? Comparing.haveEqualElements(roots, ((MyContentComponent)component).getRoots()) : false;
                if (!bl2) continue;
                content2 = element$iv;
                break block2;
            }
            content2 = null;
        }
        if (content2 == null) {
            return false;
        }
        Content content5 = content2;
        cm.setSelectedContent(content5);
        return true;
    }

    private static final void doOnProviderRemoval(Project project, Disposable disposable, Function0<Unit> closeTab) {
        VcsLogProvider.LOG_PROVIDER_EP.getPoint((AreaInstance)project).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<VcsLogProvider>(closeTab){
            final /* synthetic */ Function0 $closeTab;

            public void extensionRemoved(@NotNull VcsLogProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (Intrinsics.areEqual((Object)extension.getSupportedVcs(), (Object)GitVcs.getKey())) {
                    this.$closeTab.invoke();
                }
            }
            {
                this.$closeTab = $captured_local_variable$0;
            }
        }, false, disposable);
    }

    public static final /* synthetic */ List access$getGitRootsFromUser(Project project) {
        return GitShowExternalLogActionKt.getGitRootsFromUser(project);
    }

    public static final /* synthetic */ boolean access$selectProjectLog(Project project, GitVcs vcs, ContentManager cm, List requestedRoots) {
        return GitShowExternalLogActionKt.selectProjectLog(project, vcs, cm, requestedRoots);
    }

    public static final /* synthetic */ boolean access$selectAlreadyOpened(ContentManager cm, Collection roots) {
        return GitShowExternalLogActionKt.selectAlreadyOpened(cm, roots);
    }

    public static final /* synthetic */ MyContentComponent access$createManagerAndContent(Project project, GitVcs vcs, List roots, boolean isToolWindowTab) {
        return GitShowExternalLogActionKt.createManagerAndContent(project, vcs, roots, isToolWindowTab);
    }

    public static final /* synthetic */ String access$calcTabName(ContentManager cm, List roots) {
        return GitShowExternalLogActionKt.calcTabName(cm, roots);
    }

    public static final /* synthetic */ void access$doOnProviderRemoval(Project project, Disposable disposable, Function0 closeTab) {
        GitShowExternalLogActionKt.doOnProviderRemoval(project, disposable, (Function0<Unit>)closeTab);
    }
}

