/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.BaseOutputReader;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.config.GitExecutable;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitTextHandler
extends GitHandler {
    private static final int WAIT_TIMEOUT_MS = 50;
    private static final int TERMINATION_TIMEOUT_MS = 60000;
    private OSProcessHandler myHandler;
    private volatile boolean myIsDestroyed;
    private final Object myProcessStateLock;
    protected boolean myWithMediator;
    private int myTerminationTimeoutMs;

    protected GitTextHandler(@Nullable Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (directory == null) {
            GitTextHandler.$$$reportNull$$$0(0);
        }
        if (command == null) {
            GitTextHandler.$$$reportNull$$$0(1);
        }
        super(project, directory, command, Collections.emptyList());
        this.myProcessStateLock = new Object();
        this.myWithMediator = true;
        this.myTerminationTimeoutMs = 60000;
    }

    protected GitTextHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        if (project == null) {
            GitTextHandler.$$$reportNull$$$0(2);
        }
        if (vcsRoot == null) {
            GitTextHandler.$$$reportNull$$$0(3);
        }
        if (command == null) {
            GitTextHandler.$$$reportNull$$$0(4);
        }
        super(project, vcsRoot, command, Collections.emptyList());
        this.myProcessStateLock = new Object();
        this.myWithMediator = true;
        this.myTerminationTimeoutMs = 60000;
    }

    protected GitTextHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, List<String> configParameters) {
        if (project == null) {
            GitTextHandler.$$$reportNull$$$0(5);
        }
        if (vcsRoot == null) {
            GitTextHandler.$$$reportNull$$$0(6);
        }
        if (command == null) {
            GitTextHandler.$$$reportNull$$$0(7);
        }
        super(project, vcsRoot, command, configParameters);
        this.myProcessStateLock = new Object();
        this.myWithMediator = true;
        this.myTerminationTimeoutMs = 60000;
    }

    public GitTextHandler(@Nullable Project project, @NotNull File directory, @NotNull GitExecutable executable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (directory == null) {
            GitTextHandler.$$$reportNull$$$0(8);
        }
        if (executable == null) {
            GitTextHandler.$$$reportNull$$$0(9);
        }
        if (command == null) {
            GitTextHandler.$$$reportNull$$$0(10);
        }
        if (configParameters == null) {
            GitTextHandler.$$$reportNull$$$0(11);
        }
        super(project, directory, executable, command, configParameters);
        this.myProcessStateLock = new Object();
        this.myWithMediator = true;
        this.myTerminationTimeoutMs = 60000;
    }

    public void setWithMediator(boolean value) {
        this.myWithMediator = value;
    }

    public void setTerminationTimeout(int timeoutMs) {
        this.myTerminationTimeoutMs = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Process startProcess() throws ExecutionException {
        Object object = this.myProcessStateLock;
        synchronized (object) {
            if (this.myIsDestroyed) {
                return null;
            }
            this.myHandler = this.createProcess(this.myCommandLine);
            return this.myHandler.getProcess();
        }
    }

    @Override
    protected void startHandlingStreams() {
        this.myHandler.addProcessListener(new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                int exitCode = event.getExitCode();
                try {
                    GitTextHandler.this.setExitCode(exitCode);
                    GitTextHandler.this.processTerminated(exitCode);
                }
                finally {
                    GitTextHandler.this.listeners().processTerminated(exitCode);
                }
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (GitHandler.OUTPUT_LOG.isDebugEnabled()) {
                    GitHandler.OUTPUT_LOG.debug(String.format("%s (%s):'%s'", GitTextHandler.this.getCommand(), outputType, event.getText()));
                }
                GitTextHandler.this.onTextAvailable(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/commands/GitTextHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myHandler.startNotify();
    }

    protected abstract void processTerminated(int var1);

    protected abstract void onTextAvailable(String var1, Key var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyProcess() {
        Object object = this.myProcessStateLock;
        synchronized (object) {
            this.myIsDestroyed = true;
            if (this.myHandler != null) {
                this.myHandler.destroyProcess();
            }
        }
    }

    @Override
    protected void waitForProcess() {
        if (this.myHandler != null) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            while (!this.myHandler.waitFor(50L)) {
                try {
                    if (indicator == null) continue;
                    indicator.checkCanceled();
                }
                catch (ProcessCanceledException pce) {
                    if (!this.tryKill()) {
                        LOG.error("Could not terminate [" + this.printableCommandLine() + "].");
                    }
                    throw pce;
                }
            }
        }
    }

    private boolean tryKill() {
        this.myHandler.destroyProcess();
        if (this.myHandler.waitFor((long)this.myTerminationTimeoutMs)) {
            return true;
        }
        LOG.warn("Soft-kill failed for [" + this.printableCommandLine() + "].");
        ExecutionManagerImpl.stopProcess((ProcessHandler)this.myHandler);
        return this.myHandler.waitFor((long)this.myTerminationTimeoutMs);
    }

    protected OSProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            GitTextHandler.$$$reportNull$$$0(12);
        }
        return new MyOSProcessHandler(commandLine, this.myWithMediator && this.myExecutable.isLocal() && Registry.is((String)"git.execute.with.mediator"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        objectArray2[1] = "git4idea/commands/GitTextHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class MyOSProcessHandler
    extends KillableProcessHandler {
        protected MyOSProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
            if (commandLine == null) {
                MyOSProcessHandler.$$$reportNull$$$0(0);
            }
            super(commandLine, withMediator);
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = Registry.is((String)"git.blocking.read") ? BaseOutputReader.Options.BLOCKING : BaseOutputReader.Options.NON_BLOCKING;
            if (options == null) {
                MyOSProcessHandler.$$$reportNull$$$0(1);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitTextHandler$MyOSProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitTextHandler$MyOSProcessHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

