/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.GitUtil;
import git4idea.branch.GitBranchIsNotFullyMergedDialog;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.commands.Git;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchUiHandlerImpl
implements GitBranchUiHandler {
    @NonNls
    private static final String RESOLVE_HREF_ATTRIBUTE = "resolve";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ProgressIndicator myProgressIndicator;

    public GitBranchUiHandlerImpl(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myGit = git;
        this.myProgressIndicator = indicator;
    }

    @Override
    public boolean notifyErrorWithRollbackProposal(@NotNull String title, @NotNull String message, @NotNull String rollbackProposal) {
        if (title == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(3);
        }
        if (message == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(4);
        }
        if (rollbackProposal == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(5);
        }
        AtomicBoolean ok = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            StringBuilder description = new StringBuilder();
            if (!StringUtil.isEmptyOrSpaces((String)message)) {
                description.append(message).append("<br/>");
            }
            description.append(rollbackProposal);
            ok.set(0 == DialogManager.showOkCancelDialog(this.myProject, XmlStringUtil.wrapInHtml((CharSequence)description), title, GitBundle.message("branch.ui.handler.rollback", new Object[0]), GitBundle.message("branch.ui.handler.do.not.rollback", new Object[0]), Messages.getErrorIcon()));
        });
        return ok.get();
    }

    @Override
    public void showUnmergedFilesNotification(final @NotNull String operationName, final @NotNull Collection<? extends GitRepository> repositories) {
        if (operationName == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(6);
        }
        if (repositories == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(7);
        }
        String title = GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName);
        String description = GitBranchUiHandlerImpl.unmergedFilesErrorNotificationDescription(operationName);
        VcsNotifier.getInstance((Project)this.myProject).notifyError("git.unresolved.conflicts", title, description, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals(GitBranchUiHandlerImpl.RESOLVE_HREF_ATTRIBUTE)) {
                    GitConflictResolver.Params params = new GitConflictResolver.Params(GitBranchUiHandlerImpl.this.myProject).setMergeDescription(GitBundle.message("branch.ui.handler.merge.notification.description", operationName)).setErrorNotificationTitle(GitBundle.message("branch.ui.handler.merge.error.notification.title", new Object[0]));
                    new GitConflictResolver(GitBranchUiHandlerImpl.this.myProject, GitUtil.getRootsFromRepositories(repositories), params).merge();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "git4idea/branch/GitBranchUiHandlerImpl$1";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public boolean showUnmergedFilesMessageWithRollback(@NotNull String operationName, @NotNull String rollbackProposal) {
        if (operationName == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(8);
        }
        if (rollbackProposal == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(9);
        }
        AtomicBoolean ok = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            String description = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("branch.ui.handler.you.have.to.resolve.all.conflicts.before.operation.name", operationName, rollbackProposal));
            ok.set(0 == DialogManager.showOkCancelDialog(this.myProject, description, GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName), GitBundle.message("branch.ui.handler.rollback", new Object[0]), GitBundle.message("branch.ui.handler.do.not.rollback", new Object[0]), Messages.getErrorIcon()));
        });
        return ok.get();
    }

    @Override
    public void showUntrackedFilesNotification(@NotNull String operationName, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (operationName == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(10);
        }
        if (root == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(11);
        }
        if (relativePaths == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(12);
        }
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, root, relativePaths, operationName, null);
    }

    @Override
    public boolean showUntrackedFilesDialogWithRollback(@NotNull String operationName, @NotNull String rollbackProposal, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (operationName == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(13);
        }
        if (rollbackProposal == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(14);
        }
        if (root == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(15);
        }
        if (relativePaths == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(16);
        }
        return GitUntrackedFilesHelper.showUntrackedFilesDialogWithRollback(this.myProject, operationName, rollbackProposal, root, relativePaths);
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        if (progressIndicator == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(17);
        }
        return progressIndicator;
    }

    @Override
    public GitSmartOperationDialog.Choice showSmartOperationDialog(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull Collection<String> paths, @NotNull String operation, @Nullable String forceButtonTitle) {
        if (project == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(18);
        }
        if (changes == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(19);
        }
        if (paths == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(20);
        }
        if (operation == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(21);
        }
        Ref exitCode = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> exitCode.set((Object)GitSmartOperationDialog.show(project, changes, paths, StringUtil.capitalize((String)operation), forceButtonTitle)));
        return (GitSmartOperationDialog.Choice)((Object)exitCode.get());
    }

    @Override
    public boolean showBranchIsNotFullyMergedDialog(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> history, @NotNull Map<GitRepository, String> baseBranches, @NotNull String removedBranch) {
        if (project == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(22);
        }
        if (history == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(23);
        }
        if (baseBranches == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(24);
        }
        if (removedBranch == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(25);
        }
        AtomicBoolean restore = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> restore.set(GitBranchIsNotFullyMergedDialog.showAndGetAnswer(this.myProject, history, baseBranches, removedBranch)));
        return restore.get();
    }

    @Override
    @NotNull
    public GitBranchUiHandler.DeleteRemoteBranchDecision confirmRemoteBranchDeletion(@NotNull List<String> branchNames, @NotNull Collection<@NlsSafe String> trackingBranches, @NotNull Collection<GitRepository> repositories) {
        String deleteButtonText;
        if (branchNames == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(26);
        }
        if (trackingBranches == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(27);
        }
        if (repositories == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(28);
        }
        boolean deleteMultipleBranches = branchNames.size() > 1;
        String title = GitBundle.message("branch.ui.handler.delete.remote.branches", branchNames.size());
        String remoteBranches = deleteMultipleBranches ? StringUtil.join(branchNames, (String)", ") : branchNames.iterator().next();
        String message = GitBundle.message("branch.ui.handler.delete.remote.branches.question", branchNames.size(), remoteBranches);
        String string = deleteButtonText = deleteMultipleBranches ? GitBundle.message("branch.ui.handler.delete.all", new Object[0]) : CommonBundle.message((String)"button.delete", (Object[])new Object[0]);
        if (trackingBranches.isEmpty()) {
            GitBranchUiHandler.DeleteRemoteBranchDecision deleteRemoteBranchDecision = 0 == DialogManager.showOkCancelDialog(this.myProject, message, title, deleteButtonText, CommonBundle.getCancelButtonText(), Messages.getQuestionIcon()) ? GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE : GitBranchUiHandler.DeleteRemoteBranchDecision.CANCEL;
            if (deleteRemoteBranchDecision == null) {
                GitBranchUiHandlerImpl.$$$reportNull$$$0(29);
            }
            return deleteRemoteBranchDecision;
        }
        String forBranch = GitBundle.message("branch.ui.handler.delete.tracking.local.branch.as.well", trackingBranches.iterator().next());
        String forBranches = new HtmlBuilder().append(GitBundle.message("branch.ui.handler.delete.tracking.local.branches", new Object[0])).br().appendWithSeparators(HtmlChunk.raw((String)(", " + HtmlChunk.br())), (Iterable)ContainerUtil.map(trackingBranches, it -> HtmlChunk.text((String)it))).wrapWith(HtmlChunk.html()).toString();
        final String checkboxMessage = trackingBranches.size() == 1 ? forBranch : forBranches;
        final Ref deleteChoice = Ref.create((Object)false);
        boolean delete = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).yesText(deleteButtonText)).noText(CommonBundle.getCancelButtonText())).doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                deleteChoice.set((Object)isSelected);
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = checkboxMessage;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUiHandlerImpl$2", "getDoNotShowMessage"));
            }
        })).ask(this.myProject);
        boolean deleteTracking = (Boolean)deleteChoice.get();
        GitBranchUiHandler.DeleteRemoteBranchDecision deleteRemoteBranchDecision = delete ? (deleteTracking ? GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE_WITH_TRACKING : GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE) : GitBranchUiHandler.DeleteRemoteBranchDecision.CANCEL;
        if (deleteRemoteBranchDecision == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(30);
        }
        return deleteRemoteBranchDecision;
    }

    @NotNull
    @NlsContexts.DialogTitle
    private static String unmergedFilesErrorTitle(@NotNull String operationName) {
        if (operationName == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(31);
        }
        String string = GitBundle.message("branch.ui.handler.can.not.operation.name.because.of.unmerged.files", operationName);
        if (string == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    @NlsContexts.NotificationContent
    private static String unmergedFilesErrorNotificationDescription(String operationName) {
        String string = GitBundle.message("branch.ui.handler.unmerged.files.error.notification", RESOLVE_HREF_ATTRIBUTE, operationName);
        if (string == null) {
            GitBranchUiHandlerImpl.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rollbackProposal";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 7: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 17: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchUiHandlerImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseBranches";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedBranch";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchNames";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackingBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchUiHandlerImpl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "confirmRemoteBranchDeletion";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "unmergedFilesErrorTitle";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "unmergedFilesErrorNotificationDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyErrorWithRollbackProposal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showUnmergedFilesNotification";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showUnmergedFilesMessageWithRollback";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesNotification";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesDialogWithRollback";
                break;
            }
            case 17: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showSmartOperationDialog";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showBranchIsNotFullyMergedDialog";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "confirmRemoteBranchDeletion";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unmergedFilesErrorTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

