/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.TitleInfoProvider;
import com.intellij.openapi.wm.impl.simpleTitleParts.RegistryOption;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.impl.ui.DebuggerTitleInfoProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u000b\u001a#\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/xdebugger/impl/ui/DebuggerTitleInfoProvider;", "Lcom/intellij/openapi/wm/impl/TitleInfoProvider;", "()V", "borderlessPrefix", "", "getBorderlessPrefix", "()Ljava/lang/String;", "borderlessSuffix", "getBorderlessSuffix", "option", "Lcom/intellij/openapi/wm/impl/simpleTitleParts/RegistryOption;", "updateListeners", "", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "provider", "", "addUpdateListener", "project", "Lcom/intellij/openapi/project/Project;", "value", "getValue", "isActive", "", "isEnabled", "updateNotify", "updateSubscriptions", "Companion", "DebuggerTitleInfoProviderService", "intellij.platform.debugger.impl"})
final class DebuggerTitleInfoProvider
implements TitleInfoProvider {
    private final RegistryOption option = new RegistryOption("ide.debug.in.title", null);
    private Set<Function1<TitleInfoProvider, Unit>> updateListeners;
    @NotNull
    private final String borderlessSuffix;
    @NotNull
    private final String borderlessPrefix;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getBorderlessSuffix() {
        return this.borderlessSuffix;
    }

    @Override
    @NotNull
    public String getBorderlessPrefix() {
        return this.borderlessPrefix;
    }

    @Override
    public void addUpdateListener(@NotNull Project project, @NotNull Function1<? super TitleInfoProvider, Unit> value2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.updateListeners.add(value2);
        this.updateSubscriptions(project);
        this.updateNotify();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEnabled() {
        if (!this.option.isActive()) return false;
        Collection collection = this.updateListeners;
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    private final void updateNotify() {
        Iterable $this$forEach$iv = this.updateListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)this);
        }
        TitleInfoProvider.Companion.fireConfigurationChanged();
    }

    @Override
    public boolean isActive(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.isEnabled() && DebuggerTitleInfoProvider.Companion.getHelper(project).getDebuggerSessionStarted();
    }

    @Override
    @NotNull
    public String getValue(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DebuggerTitleInfoProvider.Companion.getHelper(project).getDebuggerSessionStarted() ? "[Debugger]" : "";
    }

    private final void updateSubscriptions(Project project) {
        DebuggerTitleInfoProviderService helper = DebuggerTitleInfoProvider.Companion.getHelper(project);
        helper.checkState(this);
        Disposable disposable2 = helper.getSubscriptionDisposable();
        if (!this.isEnabled()) {
            helper.setSubscriptionDisposable(null);
            if (disposable2 != null) {
                Disposer.dispose((Disposable)disposable2);
            }
            return;
        }
        if (disposable2 == null) {
            helper.setSubscriptionDisposable(helper.addSubscription(this));
        }
    }

    public DebuggerTitleInfoProvider() {
        this.option.setListener((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                ProjectManager projectManager = ProjectManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
                Project[] projectArray = projectManager.getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
                Project[] $this$forEach$iv = projectArray;
                boolean $i$f$forEach = false;
                Project[] projectArray2 = $this$forEach$iv;
                int n = projectArray2.length;
                for (int j = 0; j < n; ++j) {
                    Project element$iv;
                    Project it = element$iv = projectArray2[j];
                    boolean bl = false;
                    Project project = it;
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"it");
                    this.updateSubscriptions(project);
                }
                this.updateNotify();
            }
        }));
        this.updateListeners = new HashSet();
        this.borderlessSuffix = "";
        this.borderlessPrefix = " ";
    }

    public static final /* synthetic */ boolean access$isEnabled(DebuggerTitleInfoProvider $this) {
        return $this.isEnabled();
    }

    @Service
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/intellij/xdebugger/impl/ui/DebuggerTitleInfoProvider$DebuggerTitleInfoProviderService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "debuggerSessionStarted", "", "getDebuggerSessionStarted", "()Z", "setDebuggerSessionStarted", "(Z)V", "subscriptionDisposable", "Lcom/intellij/openapi/Disposable;", "getSubscriptionDisposable", "()Lcom/intellij/openapi/Disposable;", "setSubscriptionDisposable", "(Lcom/intellij/openapi/Disposable;)V", "addSubscription", "provider", "Lcom/intellij/xdebugger/impl/ui/DebuggerTitleInfoProvider;", "checkState", "", "intellij.platform.debugger.impl"})
    private static final class DebuggerTitleInfoProviderService {
        private boolean debuggerSessionStarted;
        @Nullable
        private Disposable subscriptionDisposable;
        private final Project project;

        public final boolean getDebuggerSessionStarted() {
            return this.debuggerSessionStarted;
        }

        public final void setDebuggerSessionStarted(boolean bl) {
            this.debuggerSessionStarted = bl;
        }

        @Nullable
        public final Disposable getSubscriptionDisposable() {
            return this.subscriptionDisposable;
        }

        public final void setSubscriptionDisposable(@Nullable Disposable disposable2) {
            this.subscriptionDisposable = disposable2;
        }

        /*
         * Unable to fully structure code
         */
        public final void checkState(@NotNull DebuggerTitleInfoProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (!DebuggerTitleInfoProvider.access$isEnabled(provider)) ** GOTO lbl-1000
            v0 = XDebuggerManager.getInstance((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"XDebuggerManager.getInstance(project)");
            v1 = v0.getDebugSessions();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"XDebuggerManager.getInst\u2026ce(project).debugSessions");
            var2_2 = v1;
            var3_3 = false;
            var4_4 = var2_2;
            var5_5 = false;
            if (var4_4.length == 0 == false) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            this.debuggerSessionStarted = v2;
            DebuggerTitleInfoProvider.access$updateNotify(provider);
        }

        @NotNull
        public final Disposable addSubscription(@NotNull DebuggerTitleInfoProvider provider2) {
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            Disposable disposable2 = new Disposable(this){
                final /* synthetic */ DebuggerTitleInfoProviderService this$0;

                public final void dispose() {
                    this.this$0.setSubscriptionDisposable(null);
                }
                {
                    this.this$0 = debuggerTitleInfoProviderService;
                }
            };
            Disposer.register((Disposable)((Disposable)this.project), (Disposable)disposable2);
            this.project.getMessageBus().connect(disposable2).subscribe(XDebuggerManager.TOPIC, (Object)new XDebuggerManagerListener(this, provider2){
                final /* synthetic */ DebuggerTitleInfoProviderService this$0;
                final /* synthetic */ DebuggerTitleInfoProvider $provider;

                public void processStarted(@NotNull XDebugProcess debugProcess) {
                    Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                    this.this$0.setDebuggerSessionStarted(true);
                    debugProcess.getSession().addSessionListener(new XDebugSessionListener(this){
                        final /* synthetic */ addSubscription.1 this$0;

                        public void sessionStopped() {
                            this.this$0.this$0.checkState(this.this$0.$provider);
                        }
                        {
                            this.this$0 = this$0;
                        }
                    });
                }

                public void processStopped(@NotNull XDebugProcess debugProcess) {
                    Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                    this.this$0.checkState(this.$provider);
                }

                public void currentSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
                    this.this$0.checkState(this.$provider);
                }
                {
                    this.this$0 = this$0;
                    this.$provider = $captured_local_variable$1;
                }
            });
            return disposable2;
        }

        public DebuggerTitleInfoProviderService(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/xdebugger/impl/ui/DebuggerTitleInfoProvider$Companion;", "", "()V", "getHelper", "Lcom/intellij/xdebugger/impl/ui/DebuggerTitleInfoProvider$DebuggerTitleInfoProviderService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private final DebuggerTitleInfoProviderService getHelper(Project project) {
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(DebuggerTitleInfoProviderService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (DebuggerTitleInfoProviderService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

