/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeWithHistoryContainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DebuggerTreeWithHistoryPopup<D>
extends DebuggerTreeWithHistoryContainer<D> {
    @NonNls
    private static final String DIMENSION_SERVICE_KEY = "DebuggerActiveHint";
    private JBPopup myPopup;
    private final Editor myEditor;
    private final Point myPoint;
    @Nullable
    private final Runnable myHideRunnable;

    private DebuggerTreeWithHistoryPopup(@NotNull D initialItem, @NotNull DebuggerTreeCreator<D> creator, @NotNull Editor editor, @NotNull Point point, @NotNull Project project, @Nullable Runnable hideRunnable) {
        if (initialItem == null) {
            DebuggerTreeWithHistoryPopup.$$$reportNull$$$0(0);
        }
        if (creator == null) {
            DebuggerTreeWithHistoryPopup.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            DebuggerTreeWithHistoryPopup.$$$reportNull$$$0(2);
        }
        if (point == null) {
            DebuggerTreeWithHistoryPopup.$$$reportNull$$$0(3);
        }
        if (project == null) {
            DebuggerTreeWithHistoryPopup.$$$reportNull$$$0(4);
        }
        super(initialItem, creator, project);
        this.myEditor = editor;
        this.myPoint = point;
        this.myHideRunnable = hideRunnable;
    }

    public static <D> void showTreePopup(@NotNull DebuggerTreeCreator<D> creator, @NotNull D initialItem, @NotNull Editor editor, @NotNull Point point, @NotNull Project project, Runnable hideRunnable) {
        if (creator == null) {
            DebuggerTreeWithHistoryPopup.$$$reportNull$$$0(5);
        }
        if (initialItem == null) {
            DebuggerTreeWithHistoryPopup.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            DebuggerTreeWithHistoryPopup.$$$reportNull$$$0(7);
        }
        if (point == null) {
            DebuggerTreeWithHistoryPopup.$$$reportNull$$$0(8);
        }
        if (project == null) {
            DebuggerTreeWithHistoryPopup.$$$reportNull$$$0(9);
        }
        new DebuggerTreeWithHistoryPopup<D>(initialItem, creator, editor, point, project, hideRunnable).updateTree(initialItem);
    }

    private TreeModelListener createTreeListener(final Tree tree) {
        return new TreeModelAdapter(){

            public void treeStructureChanged(TreeModelEvent e) {
                DebuggerTreeWithHistoryPopup.this.resize(e.getTreePath(), (JTree)tree);
            }
        };
    }

    @Override
    protected void updateContainer(Tree tree, @NlsContexts.PopupTitle String title) {
        if (this.myPopup != null) {
            this.myPopup.cancel();
        }
        tree.getModel().addTreeModelListener(this.createTreeListener(tree));
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.createMainPanel(tree), (JComponent)tree).setRequestFocus(true).setTitle(title).setResizable(true).setMovable(true).setDimensionServiceKey(this.myProject, DIMENSION_SERVICE_KEY, false).setMayBeParent(true).setCancelOnOtherWindowOpen(true).setKeyEventHandler(event -> {
            if (AbstractPopup.isCloseRequest(event)) {
                SpeedSearchSupply supply = SpeedSearchSupply.getSupply((JComponent)tree);
                return supply != null && StringUtil.isEmpty((String)supply.getEnteredPrefix());
            }
            return false;
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (DebuggerTreeWithHistoryPopup.this.myHideRunnable != null) {
                    DebuggerTreeWithHistoryPopup.this.myHideRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup$2", "onClosed"));
            }
        }).setCancelCallback(() -> {
            Window parent = SwingUtilities.getWindowAncestor((Component)tree);
            if (parent != null) {
                for (Window child2 : parent.getOwnedWindows()) {
                    if (!child2.isShowing()) continue;
                    return false;
                }
            }
            return true;
        }).createPopup();
        DebuggerTreeWithHistoryPopup.registerTreeDisposable((Disposable)this.myPopup, tree);
        if (this.myEditor.getComponent().getRootPane() == null) {
            this.myPopup.cancel();
            return;
        }
        this.myPopup.show(new RelativePoint((Component)this.myEditor.getContentComponent(), this.myPoint));
        this.updateInitialBounds(tree);
    }

    private void resize(TreePath path, JTree tree) {
        if (this.myPopup == null || !this.myPopup.isVisible() || this.myPopup.isDisposed()) {
            return;
        }
        Window popupWindow = SwingUtilities.windowForComponent(this.myPopup.getContent());
        if (popupWindow == null) {
            return;
        }
        Dimension size = tree.getPreferredSize();
        Point location = popupWindow.getLocation();
        Rectangle windowBounds = popupWindow.getBounds();
        Rectangle bounds2 = tree.getPathBounds(path);
        if (bounds2 == null) {
            return;
        }
        Rectangle targetBounds = new Rectangle(location.x, location.y, Math.max(Math.max(size.width, bounds2.width) + 20, windowBounds.width), Math.max(tree.getRowCount() * bounds2.height + 55, windowBounds.height));
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)targetBounds);
        popupWindow.setBounds(targetBounds);
        popupWindow.validate();
        popupWindow.repaint();
    }

    private void updateInitialBounds(Tree tree) {
        Window popupWindow = SwingUtilities.windowForComponent(this.myPopup.getContent());
        Dimension size = tree.getPreferredSize();
        Point location = popupWindow.getLocation();
        Rectangle windowBounds = popupWindow.getBounds();
        Rectangle targetBounds = new Rectangle(location.x, location.y, Math.max(size.width + 250, windowBounds.width), Math.max(size.height, windowBounds.height));
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)targetBounds);
        popupWindow.setBounds(targetBounds);
        popupWindow.validate();
        popupWindow.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialItem";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showTreePopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

