/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/BreakpointsUtilValidator;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "()V", "acceptRuleId", "", "ruleId", "", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "intellij.platform.debugger.impl"})
public final class BreakpointsUtilValidator
extends CustomValidationRule {
    public boolean acceptRuleId(@Nullable String ruleId) {
        return Intrinsics.areEqual((Object)"breakpoint", (Object)ruleId);
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ("custom".equals(data2)) {
            return ValidationResultType.ACCEPTED;
        }
        ExtensionPointName extensionPointName = XBreakpointType.EXTENSION_POINT_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"XBreakpointType.EXTENSION_POINT_NAME");
        for (XBreakpointType breakpoint : (XBreakpointType[])extensionPointName.getExtensions()) {
            if (!StringUtil.equals((CharSequence)breakpoint.getId(), (CharSequence)data2)) continue;
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(breakpoint.getClass());
            return info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
        }
        return ValidationResultType.REJECTED;
    }
}

