/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntityData;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityId;
import com.intellij.workspaceModel.storage.impl.MutableStorageIndexes;
import com.intellij.workspaceModel.storage.impl.SoftLinkable;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.workspaceModel.storage.impl.indices.MultimapStorageIndex;
import com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 (2\u00020\u0001:\u0001(B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0007\u00a2\u0006\u0002\u0010\u000bBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0007\u0012\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\r\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0010\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0#H\u0002J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010&\u001a\u00020'R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\rX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0007X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "", "softLinks", "Lcom/intellij/workspaceModel/storage/impl/indices/MultimapStorageIndex;", "virtualFileIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;", "entitySourceIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "persistentIdIndex", "Lcom/intellij/workspaceModel/storage/PersistentEntityId;", "(Lcom/intellij/workspaceModel/storage/impl/indices/MultimapStorageIndex;Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;)V", "externalMappings", "", "", "Lcom/intellij/workspaceModel/storage/impl/external/ExternalEntityMappingImpl;", "(Lcom/intellij/workspaceModel/storage/impl/indices/MultimapStorageIndex;Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;Ljava/util/Map;)V", "getEntitySourceIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;", "getExternalMappings$intellij_platform_workspaceModel_storage", "()Ljava/util/Map;", "getPersistentIdIndex$intellij_platform_workspaceModel_storage", "getSoftLinks$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/MultimapStorageIndex;", "getVirtualFileIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;", "assertConsistency", "", "storage", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "assertEntitySourceIndex", "assertModuleSoftLinks", "entityData", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntityData;", "expectedLinks", "", "assertPersistentIdIndex", "assertSoftLinksIndex", "toMutable", "Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;", "Companion", "intellij.platform.workspaceModel.storage"})
public class StorageIndexes {
    @NotNull
    private final MultimapStorageIndex softLinks;
    @NotNull
    private final VirtualFileIndex virtualFileIndex;
    @NotNull
    private final EntityStorageInternalIndex<EntitySource> entitySourceIndex;
    @NotNull
    private final EntityStorageInternalIndex<PersistentEntityId<?>> persistentIdIndex;
    @NotNull
    private final Map<String, ExternalEntityMappingImpl<?>> externalMappings;
    @NotNull
    private static final StorageIndexes EMPTY;
    public static final Companion Companion;

    @NotNull
    public final MutableStorageIndexes toMutable() {
        MultimapStorageIndex.MutableMultimapStorageIndex copiedSoftLinks = MultimapStorageIndex.MutableMultimapStorageIndex.Companion.from(this.getSoftLinks$intellij_platform_workspaceModel_storage());
        VirtualFileIndex.MutableVirtualFileIndex copiedVirtualFileIndex = VirtualFileIndex.MutableVirtualFileIndex.Companion.from(this.getVirtualFileIndex$intellij_platform_workspaceModel_storage());
        EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> copiedEntitySourceIndex = EntityStorageInternalIndex.MutableEntityStorageInternalIndex.Companion.from(this.getEntitySourceIndex$intellij_platform_workspaceModel_storage());
        EntityStorageInternalIndex.MutableEntityStorageInternalIndex<PersistentEntityId<?>> copiedPersistentIdIndex = EntityStorageInternalIndex.MutableEntityStorageInternalIndex.Companion.from(this.getPersistentIdIndex$intellij_platform_workspaceModel_storage());
        Map<String, MutableExternalEntityMappingImpl<?>> copiedExternalMappings = MutableExternalEntityMappingImpl.Companion.fromMap(this.getExternalMappings$intellij_platform_workspaceModel_storage());
        return new MutableStorageIndexes(copiedSoftLinks, copiedVirtualFileIndex, copiedEntitySourceIndex, copiedPersistentIdIndex, copiedExternalMappings);
    }

    /*
     * WARNING - void declaration
     */
    public final void assertConsistency(@NotNull AbstractEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.assertEntitySourceIndex(storage);
        this.assertPersistentIdIndex(storage);
        this.assertSoftLinksIndex(storage);
        Map<String, ExternalEntityMappingImpl<?>> map2 = this.getExternalMappings$intellij_platform_workspaceModel_storage();
        boolean bl = false;
        for (Map.Entry<String, ExternalEntityMappingImpl<?>> entry : map2.entrySet()) {
            Map.Entry<String, ExternalEntityMappingImpl<Object>> entry2 = entry;
            boolean bl2 = false;
            ExternalEntityMappingImpl<?> mappings = entry2.getValue();
            Object object = (Map)mappings.getIndex$intellij_platform_workspaceModel_storage();
            boolean bl3 = false;
            Iterator iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                void id2;
                Map.Entry<String, ExternalEntityMappingImpl<Object>> entry3 = entry2 = iterator2.next();
                boolean bl4 = false;
                object = (EntityId)((Object)entry3.getKey());
                entry3 = entry2;
                bl4 = false;
                ExternalEntityMappingImpl<Object> obj = entry3.getValue();
                void v0 = id2;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"id");
                boolean bl5 = storage.entityDataById$intellij_platform_workspaceModel_storage((EntityId)v0) != null;
                bl4 = false;
                if (!_Assertions.ENABLED || bl5) continue;
                boolean bl6 = false;
                String string = "Missing entity by id: " + id2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertSoftLinksIndex(AbstractEntityStorage storage) {
        Iterable $this$forEachIndexed$iv = storage.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object v0;
            void family;
            int i2;
            block9: {
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EntityFamily entityFamily = (EntityFamily)item$iv;
                i2 = n;
                boolean bl2 = false;
                if (family == null) continue;
                Iterable $this$firstOrNull$iv = family.getEntities$intellij_platform_workspaceModel_storage();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    WorkspaceEntityData it = (WorkspaceEntityData)element$iv;
                    boolean bl3 = false;
                    if (!(it != null)) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            if (!(v0 instanceof SoftLinkable)) continue;
            EntityId mutableId = new EntityId(0, i2);
            Iterable $this$forEach$iv = family.getEntities$intellij_platform_workspaceModel_storage();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                boolean bl4;
                boolean bl5;
                Set<PersistentEntityId<?>> actualLinks;
                Set<PersistentEntityId<?>> expectedLinks;
                block10: {
                    WorkspaceEntityData data2 = (WorkspaceEntityData)element$iv;
                    boolean bl6 = false;
                    if (data2 == null) continue;
                    mutableId = EntityId.copy$default(mutableId, data2.getId(), 0, 2, null);
                    expectedLinks = this.getSoftLinks$intellij_platform_workspaceModel_storage().getEntriesById$intellij_platform_workspaceModel_storage(mutableId);
                    if (data2 instanceof ModuleEntityData) {
                        this.assertModuleSoftLinks((ModuleEntityData)data2, expectedLinks);
                        continue;
                    }
                    actualLinks = ((SoftLinkable)((Object)data2)).getLinks();
                    bl5 = expectedLinks.size() == actualLinks.size();
                    bl4 = false;
                    if (_Assertions.ENABLED && !bl5) {
                        boolean $i$a$-assert-StorageIndexes$assertSoftLinksIndex$1$2$22 = false;
                        String $i$a$-assert-StorageIndexes$assertSoftLinksIndex$1$2$22 = "Different sizes: " + expectedLinks + ", " + actualLinks;
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-StorageIndexes$assertSoftLinksIndex$1$2$22));
                    }
                    Iterable $this$all$iv = expectedLinks;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            PersistentEntityId it = (PersistentEntityId)element$iv2;
                            boolean bl7 = false;
                            if (actualLinks.contains(it)) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
                bl5 = bl;
                bl4 = false;
                if (!_Assertions.ENABLED || bl5) continue;
                boolean bl8 = false;
                String string = "Different sets: " + expectedLinks + ", " + actualLinks;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    private final void assertModuleSoftLinks(ModuleEntityData entityData, Set<? extends PersistentEntityId<?>> expectedLinks) {
        HashSet actualRefs = new HashSet(entityData.getDependencies().size());
        Iterable $this$forEach$iv = entityData.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PersistentEntityId persistentEntityId;
            Collection collection;
            boolean bl;
            ModuleDependencyItem dependency = (ModuleDependencyItem)element$iv;
            boolean bl2 = false;
            ModuleDependencyItem moduleDependencyItem = dependency;
            if (moduleDependencyItem instanceof ModuleDependencyItem.Exportable.ModuleDependency) {
                boolean bl3 = expectedLinks.contains(((ModuleDependencyItem.Exportable.ModuleDependency)dependency).getModule());
                boolean bl4 = false;
                bl = false;
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                collection = actualRefs;
                persistentEntityId = ((ModuleDependencyItem.Exportable.ModuleDependency)dependency).getModule();
                bl = false;
                collection.add(persistentEntityId);
                continue;
            }
            if (!(moduleDependencyItem instanceof ModuleDependencyItem.Exportable.LibraryDependency)) continue;
            boolean bl6 = expectedLinks.contains(((ModuleDependencyItem.Exportable.LibraryDependency)dependency).getLibrary());
            boolean bl7 = false;
            bl = false;
            if (_Assertions.ENABLED && !bl6) {
                boolean bl8 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            collection = actualRefs;
            persistentEntityId = ((ModuleDependencyItem.Exportable.LibraryDependency)dependency).getLibrary();
            bl = false;
            collection.add(persistentEntityId);
        }
        boolean bl = actualRefs.size() == expectedLinks.size();
        boolean bl9 = false;
        boolean bl10 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl11 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertPersistentIdIndex(AbstractEntityStorage storage) {
        int expectedSize = 0;
        Iterable $this$forEachIndexed$iv = storage.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object v0;
            void family;
            int i2;
            block6: {
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EntityFamily entityFamily = (EntityFamily)item$iv;
                i2 = n;
                boolean bl2 = false;
                if (family == null) continue;
                Iterable $this$firstOrNull$iv = family.getEntities$intellij_platform_workspaceModel_storage();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    WorkspaceEntityData it = (WorkspaceEntityData)element$iv;
                    boolean bl3 = false;
                    if (!(it != null)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            WorkspaceEntityData workspaceEntityData = v0;
            if ((workspaceEntityData != null ? EntitiesKt.persistentId(workspaceEntityData, storage) : null) == null) continue;
            EntityId mutableId = new EntityId(0, i2);
            Iterable $this$forEach$iv = family.getEntities$intellij_platform_workspaceModel_storage();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceEntityData data2 = (WorkspaceEntityData)element$iv;
                boolean bl = false;
                if (data2 == null) continue;
                mutableId = EntityId.copy$default(mutableId, data2.getId(), 0, 2, null);
                PersistentEntityId<?> expectedPersistentId = this.getPersistentIdIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(mutableId);
                int n = Intrinsics.areEqual(expectedPersistentId, EntitiesKt.persistentId(data2, storage));
                boolean bl4 = false;
                if (_Assertions.ENABLED && n == 0) {
                    boolean bl5 = false;
                    String string = "Entity " + data2 + " isn't found in persistent id index. PersistentId: " + EntitiesKt.persistentId(data2, storage) + ", Id: " + mutableId + ". Expected entity source: " + expectedPersistentId;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                n = expectedSize;
                expectedSize = n + 1;
            }
        }
        boolean bl = expectedSize == this.getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIndex$intellij_platform_workspaceModel_storage().size();
        boolean bl6 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl7 = false;
            String string = "Incorrect size of persistent id index. Expected: " + expectedSize + ", actual: " + this.getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIndex$intellij_platform_workspaceModel_storage().size();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertEntitySourceIndex(AbstractEntityStorage storage) {
        int expectedSize = 0;
        Iterable $this$forEachIndexed$iv = storage.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void family;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EntityFamily entityFamily = (EntityFamily)item$iv;
            int i2 = n;
            boolean bl2 = false;
            if (family == null) continue;
            EntityId mutableId = new EntityId(0, i2);
            Iterable $this$forEach$iv = family.getEntities$intellij_platform_workspaceModel_storage();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceEntityData data2 = (WorkspaceEntityData)element$iv;
                boolean bl3 = false;
                if (data2 == null) continue;
                mutableId = EntityId.copy$default(mutableId, data2.getId(), 0, 2, null);
                EntitySource expectedEntitySource = this.getEntitySourceIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(mutableId);
                int n2 = Intrinsics.areEqual((Object)expectedEntitySource, (Object)data2.getEntitySource());
                boolean bl4 = false;
                if (_Assertions.ENABLED && n2 == 0) {
                    boolean bl5 = false;
                    String string = "Entity " + data2 + " isn't found in entity source index. Entity source: " + data2.getEntitySource() + ", Id: " + mutableId + ". Expected entity source: " + expectedEntitySource;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                n2 = expectedSize;
                expectedSize = n2 + 1;
            }
        }
        boolean bl = expectedSize == this.getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIndex$intellij_platform_workspaceModel_storage().size();
        boolean bl6 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl7 = false;
            String string = "Incorrect size of entity source index. Expected: " + expectedSize + ", actual: " + this.getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIndex$intellij_platform_workspaceModel_storage().size();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @NotNull
    public MultimapStorageIndex getSoftLinks$intellij_platform_workspaceModel_storage() {
        return this.softLinks;
    }

    @NotNull
    public VirtualFileIndex getVirtualFileIndex$intellij_platform_workspaceModel_storage() {
        return this.virtualFileIndex;
    }

    @NotNull
    public EntityStorageInternalIndex<EntitySource> getEntitySourceIndex$intellij_platform_workspaceModel_storage() {
        return this.entitySourceIndex;
    }

    @NotNull
    public EntityStorageInternalIndex<PersistentEntityId<?>> getPersistentIdIndex$intellij_platform_workspaceModel_storage() {
        return this.persistentIdIndex;
    }

    @NotNull
    public Map<String, ExternalEntityMappingImpl<?>> getExternalMappings$intellij_platform_workspaceModel_storage() {
        return this.externalMappings;
    }

    public StorageIndexes(@NotNull MultimapStorageIndex softLinks, @NotNull VirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull EntityStorageInternalIndex<PersistentEntityId<?>> persistentIdIndex, @NotNull Map<String, ? extends ExternalEntityMappingImpl<?>> externalMappings) {
        Intrinsics.checkNotNullParameter((Object)softLinks, (String)"softLinks");
        Intrinsics.checkNotNullParameter((Object)virtualFileIndex, (String)"virtualFileIndex");
        Intrinsics.checkNotNullParameter(entitySourceIndex, (String)"entitySourceIndex");
        Intrinsics.checkNotNullParameter(persistentIdIndex, (String)"persistentIdIndex");
        Intrinsics.checkNotNullParameter(externalMappings, (String)"externalMappings");
        this.softLinks = softLinks;
        this.virtualFileIndex = virtualFileIndex;
        this.entitySourceIndex = entitySourceIndex;
        this.persistentIdIndex = persistentIdIndex;
        this.externalMappings = externalMappings;
    }

    public StorageIndexes(@NotNull MultimapStorageIndex softLinks, @NotNull VirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull EntityStorageInternalIndex<PersistentEntityId<?>> persistentIdIndex) {
        Intrinsics.checkNotNullParameter((Object)softLinks, (String)"softLinks");
        Intrinsics.checkNotNullParameter((Object)virtualFileIndex, (String)"virtualFileIndex");
        Intrinsics.checkNotNullParameter(entitySourceIndex, (String)"entitySourceIndex");
        Intrinsics.checkNotNullParameter(persistentIdIndex, (String)"persistentIdIndex");
        this(softLinks, virtualFileIndex, entitySourceIndex, persistentIdIndex, MapsKt.emptyMap());
    }

    static {
        Companion = new Companion(null);
        EMPTY = new StorageIndexes(new MultimapStorageIndex(), new VirtualFileIndex(), new EntityStorageInternalIndex<EntitySource>(false), new EntityStorageInternalIndex(true), new HashMap());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/workspaceModel/storage/impl/StorageIndexes$Companion;", "", "()V", "EMPTY", "Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "getEMPTY", "()Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        @NotNull
        public final StorageIndexes getEMPTY() {
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

