/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIterator;", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/roots/libraries/Library;)V", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "getDebugName", "", "getIndexingProgressText", "getRootsScanningProgressText", "iterateFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "visitedFileSet", "Lcom/intellij/util/containers/ConcurrentBitSet;", "intellij.platform.lang.impl"})
public final class LibraryIndexableFilesIterator
implements IndexableFilesIterator {
    @NotNull
    private final Library library;

    @NotNull
    public String getDebugName() {
        return "Library " + this.library.getPresentableName();
    }

    @Nullable
    public String getIndexingProgressText() {
        return IndexingBundle.message((String)"indexable.files.provider.indexing.library.name", (Object[])new Object[]{this.library.getPresentableName()});
    }

    @NotNull
    public String getRootsScanningProgressText() {
        String libraryName = this.library.getName();
        CharSequence charSequence = libraryName;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = IndexingBundle.message((String)"indexable.files.provider.scanning.library.name", (Object[])new Object[]{libraryName});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IndexingBundle.message(\"\u2026brary.name\", libraryName)");
            return string;
        }
        String string = IndexingBundle.message((String)"indexable.files.provider.scanning.additional.dependencies", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IndexingBundle.message(\"\u2026additional.dependencies\")");
        return string;
    }

    public boolean iterateFiles(@NotNull Project project, @NotNull ContentIterator fileIterator, @NotNull ConcurrentBitSet visitedFileSet) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)visitedFileSet, (String)"visitedFileSet");
        boolean $i$f$runReadAction = false;
        List roots = (List)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
            final /* synthetic */ LibraryIndexableFilesIterator this$0;
            {
                this.this$0 = libraryIndexableFilesIterator;
            }

            public final T compute() {
                List list2;
                boolean bl = false;
                if (Disposer.isDisposed((Disposable)((Disposable)this.this$0.getLibrary()))) {
                    boolean bl2 = false;
                    list2 = CollectionsKt.emptyList();
                } else {
                    RootProvider rootProvider = this.this$0.getLibrary().getRootProvider();
                    Intrinsics.checkNotNullExpressionValue((Object)rootProvider, (String)"library.rootProvider");
                    RootProvider rootProvider2 = rootProvider;
                    Object[] objectArray = rootProvider2.getFiles(OrderRootType.SOURCES);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"rootProvider.getFiles(OrderRootType.SOURCES)");
                    Collection collection = ArraysKt.toList((Object[])objectArray);
                    Object[] objectArray2 = rootProvider2.getFiles(OrderRootType.CLASSES);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"rootProvider.getFiles(OrderRootType.CLASSES)");
                    list2 = CollectionsKt.plus((Collection)collection, (Object[])objectArray2);
                }
                return (T)list2;
            }
        });
        return IndexableFilesIterationMethods.INSTANCE.iterateNonExcludedRoots(project, roots, fileIterator, visitedFileSet);
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    public LibraryIndexableFilesIterator(@NotNull Library library2) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        this.library = library2;
    }
}

