/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.IndexableSetContributorModificationTracker;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdditionalIndexableFileSet
implements IndexableFileSet {
    @Nullable
    private final Project myProject;
    private final Supplier<IndexableSetContributor[]> myExtensions;
    private final CachedValue<AdditionalIndexableRoots> myAdditionalIndexableRoots;

    public AdditionalIndexableFileSet(@Nullable Project project, IndexableSetContributor ... extensions2) {
        if (extensions2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myExtensions = () -> extensions2;
        this.myAdditionalIndexableRoots = new CachedValueImpl<AdditionalIndexableRoots>(() -> new CachedValueProvider.Result((Object)this.collectFilesAndDirectories(), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
    }

    public AdditionalIndexableFileSet(@Nullable Project project) {
        this.myProject = project;
        this.myExtensions = () -> (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions();
        this.myAdditionalIndexableRoots = new CachedValueImpl<AdditionalIndexableRoots>(() -> new CachedValueProvider.Result((Object)this.collectFilesAndDirectories(), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, IndexableSetContributorModificationTracker.getInstance()}));
    }

    @NotNull
    private AdditionalIndexableRoots collectFilesAndDirectories() {
        THashSet files2 = new THashSet();
        THashSet directories = new THashSet();
        for (IndexableSetContributor contributor : this.myExtensions.get()) {
            for (VirtualFile root : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                (root.isDirectory() ? directories : files2).add(root);
            }
            if (this.myProject == null) continue;
            Set projectRoots = IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)contributor, (Project)this.myProject);
            for (VirtualFile root : projectRoots) {
                (root.isDirectory() ? directories : files2).add(root);
            }
        }
        return new AdditionalIndexableRoots((Set<VirtualFile>)files2, (Set<VirtualFile>)directories);
    }

    public boolean isInSet(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(1);
        }
        AdditionalIndexableRoots additionalIndexableRoots = (AdditionalIndexableRoots)this.myAdditionalIndexableRoots.getValue();
        return VfsUtilCore.isUnder((VirtualFile)file2, additionalIndexableRoots.directories) || additionalIndexableRoots.files.contains(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/AdditionalIndexableFileSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class AdditionalIndexableRoots {
        @NotNull
        private final Set<VirtualFile> files;
        @NotNull
        private final Set<VirtualFile> directories;

        private AdditionalIndexableRoots(@NotNull Set<VirtualFile> files2, @NotNull Set<VirtualFile> directories) {
            if (files2 == null) {
                AdditionalIndexableRoots.$$$reportNull$$$0(0);
            }
            if (directories == null) {
                AdditionalIndexableRoots.$$$reportNull$$$0(1);
            }
            this.files = files2;
            this.directories = directories;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "files";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "directories";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/indexing/AdditionalIndexableFileSet$AdditionalIndexableRoots";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

