/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.win;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.ui.win.Task;
import com.intellij.util.loader.NativeLibraryLoader;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RecentTasks {
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final WeakReference<Thread> openerThread;
    private static final String openerThreadName;

    private static synchronized void init() {
        if (initialized.compareAndSet(false, true)) {
            RecentTasks.initialize(ApplicationNamesInfo.getInstance().getFullProductName() + "." + PathManager.getConfigPath().hashCode());
        }
    }

    private static native void initialize(String var0);

    private static native void addTasksNativeForCategory(String var0, Task[] var1);

    static native String getShortenPath(String var0);

    private static native void clearNative();

    public static synchronized void clear() {
        RecentTasks.init();
        RecentTasks.checkThread();
        RecentTasks.clearNative();
    }

    public static synchronized void addTasks(Task[] tasks) {
        if (tasks.length == 0) {
            return;
        }
        RecentTasks.init();
        RecentTasks.checkThread();
        RecentTasks.addTasksNativeForCategory("Recent", tasks);
    }

    private static void checkThread() {
        Thread thread = Thread.currentThread();
        if (!thread.equals(openerThread.get())) {
            throw new RuntimeException("Current thread is '" + thread.getName() + "'; this class should be used from '" + openerThreadName + "'");
        }
    }

    static {
        Thread thread = Thread.currentThread();
        openerThread = new WeakReference<Thread>(thread);
        openerThreadName = thread.getName();
        NativeLibraryLoader.loadPlatformLibrary((String)"jumpListBridge");
    }
}

