/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ide.ui.VirtualFileAppearanceListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SameThreadExecutor;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconDeferrerImpl
extends IconDeferrer {
    private static final ThreadLocal<Boolean> evaluationIsInProgress = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final Cache<Object, Icon> iconCache = Caffeine.newBuilder().maximumSize((long)SystemProperties.getIntProperty((String)"ide.icons.deferrerCacheSize", (int)1000)).executor(SameThreadExecutor.INSTANCE).build();
    private final AtomicLong lastClearTimestamp = new AtomicLong();

    public IconDeferrerImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(PsiModificationTracker.TOPIC, this::clearCache);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                IconDeferrerImpl.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ui/IconDeferrerImpl$1", "after"));
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                IconDeferrerImpl.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/IconDeferrerImpl$2", "projectClosed"));
            }
        });
        connection.subscribe(VirtualFileAppearanceListener.TOPIC, (Object)new VirtualFileAppearanceListener(){

            public void virtualFileAppearanceChanged(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                IconDeferrerImpl.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ui/IconDeferrerImpl$3", "virtualFileAppearanceChanged"));
            }
        });
        LowMemoryWatcher.register(this::clearCache, (Disposable)connection);
    }

    public final void clearCache() {
        this.lastClearTimestamp.incrementAndGet();
        this.iconCache.invalidateAll();
    }

    @NotNull
    public <T> Icon defer(@Nullable Icon base, T param, @NotNull Function<? super T, ? extends Icon> evaluator) {
        if (evaluator == null) {
            IconDeferrerImpl.$$$reportNull$$$0(0);
        }
        return this.deferImpl(base, param, evaluator, false);
    }

    public <T> Icon deferAutoUpdatable(Icon base, T param, @NotNull Function<? super T, ? extends Icon> evaluator) {
        if (evaluator == null) {
            IconDeferrerImpl.$$$reportNull$$$0(1);
        }
        return this.deferImpl(base, param, evaluator, true);
    }

    @NotNull
    private <T> Icon deferImpl(Icon base, T param, @NotNull Function<? super T, ? extends Icon> evaluator, boolean autoUpdatable) {
        if (evaluator == null) {
            IconDeferrerImpl.$$$reportNull$$$0(2);
        }
        if (evaluationIsInProgress.get().booleanValue()) {
            Icon icon2 = evaluator.apply(param);
            if (icon2 == null) {
                IconDeferrerImpl.$$$reportNull$$$0(3);
            }
            return icon2;
        }
        Icon icon3 = Objects.requireNonNull((Icon)this.iconCache.get(param, param1 -> {
            long started = this.lastClearTimestamp.get();
            return new DeferredIconImpl<Object>(base, param1, evaluator, (source, key, r) -> {
                if (started == this.lastClearTimestamp.get()) {
                    this.iconCache.put(key, autoUpdatable ? source : r);
                }
            }, autoUpdatable);
        }));
        if (icon3 == null) {
            IconDeferrerImpl.$$$reportNull$$$0(4);
        }
        return icon3;
    }

    static void evaluateDeferred(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            IconDeferrerImpl.$$$reportNull$$$0(5);
        }
        try {
            evaluationIsInProgress.set(Boolean.TRUE);
            runnable2.run();
        }
        finally {
            evaluationIsInProgress.set(Boolean.FALSE);
        }
    }

    public boolean equalIcons(Icon icon1, Icon icon2) {
        return DeferredIconImpl.equalIcons(icon1, icon2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/IconDeferrerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/IconDeferrerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deferImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "defer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deferAutoUpdatable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deferImpl";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDeferred";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

