/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionPresentation;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalActionUtil {
    private TerminalActionUtil() {
    }

    @Nullable
    public static TerminalAction createTerminalAction(@NotNull JBTerminalWidget widget, @NonNls @NotNull String actionId, boolean hiddenAction) {
        List<KeyStroke> keyStrokes;
        if (widget == null) {
            TerminalActionUtil.$$$reportNull$$$0(0);
        }
        if (actionId == null) {
            TerminalActionUtil.$$$reportNull$$$0(1);
        }
        if ((keyStrokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId(actionId)).isEmpty() && hiddenAction) {
            return null;
        }
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        if (action2 == null) {
            throw new AssertionError((Object)("Cannot find action " + actionId));
        }
        String name = action2.getTemplateText();
        if (name != null && !hiddenAction) {
            throw new AssertionError((Object)("Action has unknown name: " + actionId));
        }
        TerminalActionPresentation presentation2 = new TerminalActionPresentation(StringUtil.notNullize((String)name, (String)"unknown"), keyStrokes);
        return new TerminalAction(presentation2, keyEvent -> {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)widget.getTerminalPanel());
            ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)AnActionEvent.createFromInputEvent((InputEvent)keyEvent, (String)"Terminal", null, (DataContext)dataContext));
            return true;
        }).withHidden(hiddenAction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "widget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "actionId";
                break;
            }
        }
        objectArray[1] = "com/intellij/terminal/actions/TerminalActionUtil";
        objectArray[2] = "createTerminalAction";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

