/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.impl;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.api.RenameUsage;
import com.intellij.refactoring.rename.api.RenameUsageSearchParameters;
import com.intellij.refactoring.rename.api.RenameUsageSearcher;
import com.intellij.refactoring.rename.impl.DefaultReferenceUsage;
import com.intellij.refactoring.rename.impl.DefaultRenameUsageSearcher$sam$java_util_function_Function$0;
import com.intellij.refactoring.rename.symbol.ReferenceRenameUsageFactory;
import com.intellij.refactoring.rename.symbol.RenameableReference;
import com.intellij.refactoring.rename.symbol.SymbolRenameTarget;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/refactoring/rename/impl/DefaultRenameUsageSearcher;", "Lcom/intellij/refactoring/rename/api/RenameUsageSearcher;", "()V", "collectSearchRequests", "", "Lcom/intellij/util/Query;", "Lcom/intellij/refactoring/rename/api/RenameUsage;", "parameters", "Lcom/intellij/refactoring/rename/api/RenameUsageSearchParameters;", "referenceRenameUsage", "reference", "Lcom/intellij/model/psi/PsiSymbolReference;", "symbolToSearchForReferences", "Lcom/intellij/model/Symbol;", "target", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "intellij.platform.lang.impl"})
public final class DefaultRenameUsageSearcher
implements RenameUsageSearcher {
    @NotNull
    public Collection<Query<? extends RenameUsage>> collectSearchRequests(@NotNull RenameUsageSearchParameters parameters2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Symbol symbol = this.symbolToSearchForReferences(parameters2.getTarget());
        if (symbol == null) {
            return CollectionsKt.emptyList();
        }
        Symbol symbol2 = symbol;
        Function1 function1 = (Function1)new Function1<PsiSymbolReference, RenameUsage>(this){

            @NotNull
            public final RenameUsage invoke(@NotNull PsiSymbolReference p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return DefaultRenameUsageSearcher.access$referenceRenameUsage((DefaultRenameUsageSearcher)this.receiver, p1);
            }
        };
        Query query2 = SearchService.getInstance().searchPsiSymbolReferences(parameters2.getProject(), symbol2, parameters2.getSearchScope()).mapping((Function)new DefaultRenameUsageSearcher$sam$java_util_function_Function$0(function1));
        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"SearchService.getInstanc\u2026g(::referenceRenameUsage)");
        Query usageQuery2 = query2;
        return CollectionsKt.listOf((Object)usageQuery2);
    }

    private final Symbol symbolToSearchForReferences(RenameTarget target2) {
        Symbol symbol;
        RenameTarget renameTarget = target2;
        if (renameTarget instanceof SymbolRenameTarget) {
            symbol = ((SymbolRenameTarget)target2).getSymbol();
        } else if (renameTarget instanceof Symbol) {
            symbol = (Symbol)target2;
        } else {
            return null;
        }
        return symbol;
    }

    private final RenameUsage referenceRenameUsage(PsiSymbolReference reference2) {
        ExtensionPointName<ReferenceRenameUsageFactory> extensionPointName = ReferenceRenameUsageFactory.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"ReferenceRenameUsageFactory.EP_NAME");
        for (ReferenceRenameUsageFactory factory2 : (ReferenceRenameUsageFactory[])extensionPointName.getExtensions()) {
            RenameUsage renameUsage = factory2.renameUsage(reference2);
            if (renameUsage == null) {
                continue;
            }
            return renameUsage;
        }
        if (reference2 instanceof RenameableReference) {
            return ((RenameableReference)reference2).getRenameUsage();
        }
        if (reference2 instanceof RenameUsage) {
            return (RenameUsage)reference2;
        }
        PsiElement psiElement = reference2.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"reference.element");
        PsiFile psiFile = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"reference.element.containingFile");
        TextRange textRange = reference2.getAbsoluteRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"reference.absoluteRange");
        return new DefaultReferenceUsage(psiFile, textRange);
    }

    public static final /* synthetic */ RenameUsage access$referenceRenameUsage(DefaultRenameUsageSearcher $this, PsiSymbolReference reference2) {
        return $this.referenceRenameUsage(reference2);
    }
}

