/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.search.IndexPatternOccurrenceImpl;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class IndexPatternSearcher
extends QueryExecutorBase<IndexPatternOccurrence, IndexPatternSearch.SearchParameters> {
    private static final String WHITESPACE = " \t";
    private static final TokenSet COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});

    public IndexPatternSearcher() {
        super(true);
    }

    public void processQuery(@NotNull IndexPatternSearch.SearchParameters queryParameters, @NotNull Processor<? super IndexPatternOccurrence> consumer2) {
        int count;
        if (queryParameters == null) {
            IndexPatternSearcher.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            IndexPatternSearcher.$$$reportNull$$$0(1);
        }
        PsiFile file2 = queryParameters.getFile();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (file2 instanceof PsiBinaryFile || file2 instanceof PsiCompiledElement || virtualFile == null) {
            return;
        }
        TodoCacheManager cacheManager = TodoCacheManager.SERVICE.getInstance((Project)file2.getProject());
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        int n = count = patternProvider != null ? cacheManager.getTodoCount(virtualFile, patternProvider) : cacheManager.getTodoCount(virtualFile, queryParameters.getPattern());
        if (count != 0) {
            IndexPatternSearcher.executeImpl(queryParameters, consumer2);
        }
    }

    protected static void executeImpl(IndexPatternSearch.SearchParameters queryParameters, Processor<? super IndexPatternOccurrence> consumer2) {
        IndexPattern[] indexPatternArray;
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        PsiFile file2 = queryParameters.getFile();
        CharSequence chars = file2.getViewProvider().getContents();
        boolean multiLine = queryParameters.isMultiLine();
        List<CommentRange> commentRanges = IndexPatternSearcher.findCommentTokenRanges(file2, chars, queryParameters.getRange(), multiLine);
        IntArrayList occurrences = new IntArrayList(1);
        if (patternProvider != null) {
            indexPatternArray = patternProvider.getIndexPatterns();
        } else {
            IndexPattern[] indexPatternArray2 = new IndexPattern[1];
            indexPatternArray = indexPatternArray2;
            indexPatternArray2[0] = queryParameters.getPattern();
        }
        IndexPattern[] patterns = indexPatternArray;
        for (int i2 = 0; i2 < commentRanges.size(); ++i2) {
            occurrences.clear();
            for (int j = patterns.length - 1; j >= 0; --j) {
                if (IndexPatternSearcher.collectPatternMatches(patterns, patterns[j], chars, commentRanges, i2, file2, queryParameters.getRange(), consumer2, (IntList)occurrences, multiLine)) continue;
                return;
            }
        }
    }

    private static List<CommentRange> findCommentTokenRanges(PsiFile file2, CharSequence chars, TextRange range2, boolean multiLine) {
        if (file2 instanceof PsiPlainTextFile) {
            FileType fType = file2.getFileType();
            if (fType instanceof CustomSyntaxTableFileType) {
                Lexer lexer = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fType, (Project)file2.getProject(), (VirtualFile)file2.getVirtualFile()).getHighlightingLexer();
                return IndexPatternSearcher.findComments(lexer, chars, range2, COMMENT_TOKENS, null, multiLine);
            }
            return Collections.singletonList(new CommentRange(0, file2.getTextLength()));
        }
        ArrayList<CommentRange> commentRanges = new ArrayList<CommentRange>();
        FileViewProvider viewProvider = file2.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        for (Language lang : relevantLanguages) {
            ParserDefinition parserDefinition;
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)lang, (Project)file2.getProject(), (VirtualFile)file2.getVirtualFile());
            Lexer lexer = syntaxHighlighter.getHighlightingLexer();
            TokenSet commentTokens = null;
            IndexPatternBuilder builderForFile = null;
            for (IndexPatternBuilder builder2 : IndexPatternBuilder.EP_NAME.getExtensionList()) {
                Lexer lexerFromBuilder = builder2.getIndexingLexer(file2);
                if (lexerFromBuilder == null) continue;
                lexer = lexerFromBuilder;
                commentTokens = builder2.getCommentTokenSet(file2);
                builderForFile = builder2;
            }
            if (builderForFile == null && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) != null) {
                commentTokens = parserDefinition.getCommentTokens();
            }
            if (commentTokens == null) continue;
            List<CommentRange> langRanges = IndexPatternSearcher.findComments(lexer, chars, range2, commentTokens, builderForFile, multiLine);
            IndexPatternSearcher.mergeCommentLists(commentRanges, langRanges);
        }
        return commentRanges;
    }

    private static void mergeCommentLists(List<CommentRange> target2, List<CommentRange> source) {
        List merged = target2.isEmpty() ? source : ContainerUtil.mergeSortedLists(target2, source, CommentRange.BY_START_OFFSET_THEN_BY_END_OFFSET, (boolean)true);
        target2.clear();
        target2.addAll(merged);
    }

    private static List<CommentRange> findComments(Lexer lexer, CharSequence chars, TextRange range2, TokenSet commentTokens, IndexPatternBuilder builderForFile, boolean multiLine) {
        IElementType tokenType;
        ArrayList<CommentRange> commentRanges = new ArrayList<CommentRange>();
        int lastEndOffset = -1;
        lexer.start(chars);
        while ((tokenType = lexer.getTokenType()) != null) {
            if (range2 != null) {
                if (lexer.getTokenEnd() > range2.getStartOffset()) {
                    if (lexer.getTokenStart() >= range2.getEndOffset() && (!multiLine || lastEndOffset < 0 || !IndexPatternSearcher.containsOneLineBreak(chars, lastEndOffset, lexer.getTokenStart()))) break;
                }
            } else {
                boolean isComment;
                boolean bl = isComment = commentTokens.contains(tokenType) || CacheUtil.isInComments(tokenType);
                if (isComment) {
                    int end;
                    int startDelta = builderForFile != null ? builderForFile.getCommentStartDelta(lexer.getTokenType(), lexer.getTokenSequence()) : 0;
                    int endDelta = builderForFile != null ? builderForFile.getCommentEndDelta(lexer.getTokenType()) : 0;
                    int start2 = lexer.getTokenStart() + startDelta;
                    if (start2 < (end = lexer.getTokenEnd() - endDelta) && end <= chars.length()) {
                        commentRanges.add(new CommentRange(start2, end, startDelta, endDelta, builderForFile == null ? "" : builderForFile.getCharsAllowedInContinuationPrefix(tokenType)));
                    }
                    lastEndOffset = end;
                }
            }
            lexer.advance();
        }
        return commentRanges;
    }

    private static boolean containsOneLineBreak(CharSequence text2, int startOffset, int endOffset) {
        boolean hasLineBreak = false;
        for (int i2 = startOffset; i2 < endOffset; ++i2) {
            if (text2.charAt(i2) != '\n') continue;
            if (hasLineBreak) {
                return false;
            }
            hasLineBreak = true;
        }
        return hasLineBreak;
    }

    private static boolean collectPatternMatches(IndexPattern[] allIndexPatterns, IndexPattern indexPattern, CharSequence chars, List<CommentRange> commentRanges, int commentNum, PsiFile file2, TextRange range2, Processor<? super IndexPatternOccurrence> consumer2, IntList matches2, boolean multiLine) {
        CommentRange commentRange = commentRanges.get(commentNum);
        int commentStart = commentRange.startOffset;
        int commentEnd = commentRange.endOffset;
        int commentPrefixLength = commentRange.prefixLength;
        int commentSuffixLength = commentRange.suffixLength;
        Pattern pattern = indexPattern.getPattern();
        if (pattern != null) {
            boolean found;
            ProgressManager.checkCanceled();
            CharSequence input = StringPattern.newBombedCharSequence((CharSequence)new CharSequenceSubSequence(chars, commentStart - commentPrefixLength, commentEnd + commentSuffixLength));
            Matcher matcher = pattern.matcher(input);
            while (found = matcher.find()) {
                int end;
                int suffixStartOffset = input.length() - commentSuffixLength;
                int start2 = IndexPatternSearcher.fitToRange(matcher.start(), commentPrefixLength, suffixStartOffset) + commentStart - commentPrefixLength;
                if (start2 != (end = IndexPatternSearcher.fitToRange(matcher.end(), commentPrefixLength, suffixStartOffset) + commentStart - commentPrefixLength) && (range2 == null || range2.getStartOffset() <= start2 && end <= range2.getEndOffset()) && !matches2.contains(start2)) {
                    List<TextRange> additionalRanges;
                    List<TextRange> list2 = additionalRanges = multiLine ? IndexPatternSearcher.findContinuation(start2, chars, allIndexPatterns, commentRanges, commentNum) : Collections.emptyList();
                    if (range2 != null && !additionalRanges.isEmpty() && ((TextRange)additionalRanges.get(additionalRanges.size() - 1)).getEndOffset() > range2.getEndOffset()) continue;
                    matches2.add(start2);
                    IndexPatternOccurrenceImpl occurrence = new IndexPatternOccurrenceImpl(file2, start2, end, indexPattern, additionalRanges);
                    if (!consumer2.process((Object)occurrence)) {
                        return false;
                    }
                }
                ProgressManager.checkCanceled();
            }
        }
        return true;
    }

    private static int fitToRange(int value2, int minValue, int maxValue) {
        return Math.max(minValue, Math.min(value2, maxValue));
    }

    private static List<TextRange> findContinuation(int mainRangeStartOffset, CharSequence text2, IndexPattern[] allIndexPatterns, List<CommentRange> commentRanges, int commentNum) {
        int refOffset;
        int continuationStartOffset;
        CommentRange commentRange = commentRanges.get(commentNum);
        int lineStartOffset = CharArrayUtil.shiftBackwardUntil((CharSequence)text2, (int)(mainRangeStartOffset - 1), (String)"\n") + 1;
        int lineEndOffset = CharArrayUtil.shiftForwardUntil((CharSequence)text2, (int)mainRangeStartOffset, (String)"\n");
        int offsetInLine = mainRangeStartOffset - lineStartOffset;
        int maxCommentStartOffsetInLine = Math.max(0, commentRange.startOffset - lineStartOffset);
        ArrayList result2 = new ArrayList();
        block0: while (lineEndOffset < text2.length() && (continuationStartOffset = CharArrayUtil.shiftForward((CharSequence)text2, (int)(refOffset = (lineStartOffset = lineEndOffset + 1) + offsetInLine), (int)(lineEndOffset = CharArrayUtil.shiftForwardUntil((CharSequence)text2, (int)lineStartOffset, (String)"\n")), (String)WHITESPACE)) != refOffset && continuationStartOffset < lineEndOffset) {
            if (continuationStartOffset >= commentRange.endOffset) {
                if (++commentNum >= commentRanges.size()) break;
                commentRange = commentRanges.get(commentNum);
                if (continuationStartOffset < commentRange.startOffset || continuationStartOffset >= commentRange.endOffset) break;
            }
            int commentStartOffset = Math.max(lineStartOffset, commentRange.startOffset);
            int continuationEndOffset = Math.min(lineEndOffset, commentRange.endOffset);
            if (refOffset < commentStartOffset || commentStartOffset > lineStartOffset + maxCommentStartOffsetInLine || CharArrayUtil.shiftBackward((CharSequence)text2, (int)commentStartOffset, (int)(refOffset - 1), (String)(WHITESPACE + commentRange.allowedContinuationPrefixChars)) + 1 != commentStartOffset) break;
            CharSequence commentText = StringPattern.newBombedCharSequence((CharSequence)text2.subSequence(commentStartOffset, continuationEndOffset));
            for (IndexPattern pattern : allIndexPatterns) {
                Pattern p = pattern.getPattern();
                if (p != null && p.matcher(commentText).find()) break block0;
            }
            result2.add(new TextRange(continuationStartOffset, continuationEndOffset));
        }
        return result2.isEmpty() ? Collections.emptyList() : result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/search/IndexPatternSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CommentRange {
        private static final Comparator<CommentRange> BY_START_OFFSET_THEN_BY_END_OFFSET = Comparator.comparingInt(o -> o.startOffset).thenComparingInt(o -> o.endOffset);
        private final int startOffset;
        private final int endOffset;
        private final int prefixLength;
        private final int suffixLength;
        private final String allowedContinuationPrefixChars;

        private CommentRange(int startOffset, int endOffset) {
            this(startOffset, endOffset, 0, 0, "");
        }

        private CommentRange(int startOffset, int endOffset, int prefixLength, int suffixLength, String chars) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.prefixLength = prefixLength;
            this.suffixLength = suffixLength;
            this.allowedContinuationPrefixChars = chars;
        }
    }
}

