/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.psi.impl.cache.impl.id.IdDataConsumer;
import com.intellij.psi.search.IndexPattern;
import gnu.trove.TObjectIntHashMap;

public final class OccurrenceConsumer {
    private final IdDataConsumer myIndexDataConsumer;
    private TObjectIntHashMap<IndexPattern> myTodoOccurrences;
    private final boolean myNeedToDo;

    public OccurrenceConsumer(IdDataConsumer indexDataConsumer, boolean needToDo) {
        this.myIndexDataConsumer = indexDataConsumer;
        this.myNeedToDo = needToDo;
    }

    public void addOccurrence(CharSequence charSequence, char[] charArray, int start2, int end, int occurrenceMask) {
        if (this.myIndexDataConsumer == null) {
            return;
        }
        if (charArray != null) {
            this.myIndexDataConsumer.addOccurrence(charArray, start2, end, occurrenceMask);
        } else {
            this.myIndexDataConsumer.addOccurrence(charSequence, start2, end, occurrenceMask);
        }
    }

    public void incTodoOccurrence(IndexPattern pattern) {
        if (this.myTodoOccurrences == null) {
            this.myTodoOccurrences = new TObjectIntHashMap();
        }
        if (!this.myTodoOccurrences.increment((Object)pattern)) {
            this.myTodoOccurrences.put((Object)pattern, 1);
        }
    }

    public int getOccurrenceCount(IndexPattern pattern) {
        if (this.myTodoOccurrences == null) {
            return 0;
        }
        return this.myTodoOccurrences.get((Object)pattern);
    }

    public boolean isNeedToDo() {
        return this.myNeedToDo;
    }
}

