/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.win32;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.win32.FileInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FastUtilHashingStrategies;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.lang.ref.Reference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Win32FsCache {
    private final IdeaWin32 myKernel = IdeaWin32.getInstance();
    private Reference<Int2ObjectMap<Map<String, FileAttributes>>> myCache;

    Win32FsCache() {
    }

    void clearCache() {
        this.myCache = null;
    }

    @NotNull
    private Int2ObjectMap<Map<String, FileAttributes>> getMap() {
        Int2ObjectMap map2 = (Int2ObjectMap)SoftReference.dereference(this.myCache);
        if (map2 == null) {
            map2 = new Int2ObjectOpenHashMap();
            this.myCache = new java.lang.ref.SoftReference<Int2ObjectMap>(map2);
        }
        Int2ObjectMap int2ObjectMap = map2;
        if (int2ObjectMap == null) {
            Win32FsCache.$$$reportNull$$$0(0);
        }
        return int2ObjectMap;
    }

    String @NotNull [] list(@NotNull VirtualFile file2) {
        int parentId;
        String path;
        FileInfo[] fileInfo;
        if (file2 == null) {
            Win32FsCache.$$$reportNull$$$0(1);
        }
        if ((fileInfo = this.myKernel.listChildren(path = file2.getPath())) == null || fileInfo.length == 0) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                Win32FsCache.$$$reportNull$$$0(2);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] names2 = new String[fileInfo.length];
        Int2ObjectMap<Map<String, FileAttributes>> map2 = this.getMap();
        Map nestedMap = (Map)map2.get(parentId = ((VirtualFileWithId)file2).getId());
        if (nestedMap == null) {
            nestedMap = CollectionFactory.createFilePathMap((int)fileInfo.length, (boolean)file2.isCaseSensitive());
            map2.put(parentId, (Object)nestedMap);
        }
        for (FileInfo info : fileInfo) {
            String name = info.getName();
            nestedMap.put(name, info.toFileAttributes());
            names2[i] = name;
        }
        if (names2 == null) {
            Win32FsCache.$$$reportNull$$$0(3);
        }
        return names2;
    }

    @Nullable
    FileAttributes getAttributes(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        VirtualFile parent;
        if (file2 == null) {
            Win32FsCache.$$$reportNull$$$0(4);
        }
        int parentId = (parent = file2.getParent()) instanceof VirtualFileWithId ? ((VirtualFileWithId)parent).getId() : -((VirtualFileWithId)file2).getId();
        Int2ObjectMap<Map<String, FileAttributes>> map2 = this.getMap();
        Object nestedMap = (Map)map2.get(parentId);
        String name = file2.getName();
        FileAttributes fileAttributes = attributes = nestedMap != null ? (FileAttributes)nestedMap.get(name) : null;
        if (attributes == null) {
            if (nestedMap != null && !(nestedMap instanceof IncompleteChildrenMap)) {
                return null;
            }
            FileInfo info = this.myKernel.getInfo(file2.getPath());
            if (info == null) {
                return null;
            }
            attributes = info.toFileAttributes();
            if (nestedMap == null) {
                nestedMap = new IncompleteChildrenMap();
                map2.put(parentId, nestedMap);
            }
            nestedMap.put(name, attributes);
        }
        return attributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/win32/Win32FsCache";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/win32/Win32FsCache";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class IncompleteChildrenMap<V>
    extends Object2ObjectOpenCustomHashMap<String, V> {
        IncompleteChildrenMap() {
            super(FastUtilHashingStrategies.getStringStrategy((boolean)SystemInfoRt.isFileSystemCaseSensitive));
        }
    }
}

