/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestsMerger {
    private static final Logger LOG = Logger.getInstance(RequestsMerger.class);
    private final Object myLock;
    private MyState myState;
    @NotNull
    private final Runnable myRunnable;
    @NotNull
    private final Consumer<? super Runnable> myExecutor;
    private final List<Runnable> myWaitingStartListeners;
    private final List<Runnable> myWaitingFinishListeners;

    public RequestsMerger(@NotNull Runnable runnable2, @NotNull Consumer<? super Runnable> executor) {
        if (runnable2 == null) {
            RequestsMerger.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            RequestsMerger.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myState = MyState.empty;
        this.myWaitingStartListeners = new ArrayList<Runnable>();
        this.myWaitingFinishListeners = new ArrayList<Runnable>();
        this.myRunnable = runnable2;
        this.myExecutor = executor;
    }

    public void request() {
        LOG.debug("ext: request");
        this.doAction(MyAction.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return MyState.empty.equals((Object)this.myState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitRefresh(Runnable runnable2) {
        LOG.debug("ext: wait refresh");
        Object object = this.myLock;
        synchronized (object) {
            this.myWaitingStartListeners.add(runnable2);
        }
        this.request();
    }

    private void run() {
        LOG.debug("worker: started refresh");
        try {
            this.doAction(MyAction.start);
            this.myRunnable.run();
        }
        finally {
            this.doAction(MyAction.finish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(MyAction action2) {
        LOG.debug("doAction: START " + action2.name());
        ArrayList<Runnable> toBeCalled = null;
        MyExitAction[] myExitActionArray = this.myLock;
        synchronized (this.myLock) {
            MyState oldState = this.myState;
            this.myState = this.myState.transition(action2);
            if (oldState.equals((Object)this.myState)) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            MyExitAction[] exitActions = MyTransitionAction.getExit(oldState, this.myState);
            LOG.debug("doAction: oldState: " + oldState.name() + ", newState: " + this.myState.name());
            if (LOG.isDebugEnabled() && exitActions != null) {
                String debugExitActions = StringUtil.join((Object[])exitActions, exitAction -> exitAction.name(), (String)" ");
                LOG.debug("exit actions: " + debugExitActions);
            }
            if (exitActions != null) {
                for (MyExitAction exitAction2 : exitActions) {
                    if (MyExitAction.markStart.equals((Object)exitAction2)) {
                        this.myWaitingFinishListeners.addAll(this.myWaitingStartListeners);
                        this.myWaitingStartListeners.clear();
                        continue;
                    }
                    if (!MyExitAction.markEnd.equals((Object)exitAction2)) continue;
                    toBeCalled = new ArrayList<Runnable>(this.myWaitingFinishListeners);
                    this.myWaitingFinishListeners.clear();
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (exitActions != null) {
                for (MyExitAction exitAction3 : exitActions) {
                    if (!MyExitAction.submitRequestToExecutor.equals((Object)exitAction3)) continue;
                    this.myExecutor.consume(() -> this.run());
                }
            }
            if (toBeCalled != null) {
                for (Runnable runnable2 : toBeCalled) {
                    runnable2.run();
                }
            }
            LOG.debug("doAction: END " + action2.name());
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "runnable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "executor";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/util/RequestsMerger";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum MyAction {
        request,
        start,
        finish;

    }

    private static enum MyExitAction {
        submitRequestToExecutor,
        markStart,
        markEnd;

    }

    private static final class MyTransitionAction {
        private static final Map<Couple<MyState>, MyExitAction[]> myMap = new HashMap<Couple<MyState>, MyExitAction[]>();

        private MyTransitionAction() {
        }

        private static void add(MyState from, MyState to, MyExitAction ... action2) {
            myMap.put((Couple<MyState>)Couple.of((Object)((Object)from), (Object)((Object)to)), action2);
        }

        public static MyExitAction @Nullable [] getExit(MyState from, MyState to) {
            return myMap.get(Couple.of((Object)((Object)from), (Object)((Object)to)));
        }

        static {
            MyTransitionAction.add(MyState.empty, MyState.requestSubmitted, MyExitAction.submitRequestToExecutor);
            MyTransitionAction.add(MyState.requestSubmitted, MyState.inProgress, MyExitAction.markStart);
            MyTransitionAction.add(MyState.inProgress, MyState.empty, MyExitAction.markEnd);
            MyTransitionAction.add(MyState.inProgressRequestSubmitted, MyState.requestSubmitted, MyExitAction.submitRequestToExecutor, MyExitAction.markEnd);
            MyTransitionAction.add(MyState.inProgressRequestSubmitted, MyState.empty, MyExitAction.markEnd);
            MyTransitionAction.add(MyState.inProgress, MyState.requestSubmitted, MyExitAction.markEnd);
        }
    }

    private static enum MyState {
        empty{

            @Override
            @NotNull
            public MyState transition(MyAction action2) {
                if (MyAction.request.equals((Object)action2)) {
                    MyState myState = requestSubmitted;
                    if (myState == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return myState;
                }
                MyState.logWrongAction(this, action2);
                1 v1 = this;
                if (v1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return v1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/RequestsMerger$MyState$1", "transition"));
            }
        }
        ,
        inProgress{

            @Override
            @NotNull
            public MyState transition(MyAction action2) {
                if (MyAction.finish.equals((Object)action2)) {
                    MyState myState = empty;
                    if (myState == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return myState;
                }
                if (MyAction.request.equals((Object)action2)) {
                    MyState myState = inProgressRequestSubmitted;
                    if (myState == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return myState;
                }
                MyState.logWrongAction(this, action2);
                2 v2 = this;
                if (v2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return v2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/RequestsMerger$MyState$2", "transition"));
            }
        }
        ,
        inProgressRequestSubmitted{

            @Override
            @NotNull
            public MyState transition(MyAction action2) {
                if (MyAction.finish.equals((Object)action2)) {
                    MyState myState = requestSubmitted;
                    if (myState == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return myState;
                }
                if (MyAction.start.equals((Object)action2)) {
                    MyState.logWrongAction(this, action2);
                }
                3 v1 = this;
                if (v1 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return v1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/RequestsMerger$MyState$3", "transition"));
            }
        }
        ,
        requestSubmitted{

            @Override
            @NotNull
            public MyState transition(MyAction action2) {
                if (MyAction.start.equals((Object)action2)) {
                    MyState myState = inProgress;
                    if (myState == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return myState;
                }
                if (MyAction.finish.equals((Object)action2)) {
                    MyState.logWrongAction(this, action2);
                    MyState myState = empty;
                    if (myState == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return myState;
                }
                4 v2 = this;
                if (v2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                return v2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/RequestsMerger$MyState$4", "transition"));
            }
        };


        @NotNull
        public abstract MyState transition(MyAction var1);

        private static void logWrongAction(MyState state, MyAction action2) {
            LOG.info("Wrong action: state=" + state.name() + ", action=" + action2.name());
        }
    }
}

