/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.importing.ExternalProjectStructureCustomizer;
import com.intellij.openapi.externalSystem.importing.ExternalProjectStructureCustomizerImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.BooleanValueHolder;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalProjectDataSelectorDialog
extends DialogWrapper {
    private static final int MAX_PATH_LENGTH = 50;
    private static final Set<? extends Key<?>> DATA_KEYS = ContainerUtil.set((Object[])new Key[]{ProjectKeys.PROJECT, ProjectKeys.MODULE});
    private static final com.intellij.openapi.util.Key<DataNode<?>> MODIFIED_NODE_KEY = com.intellij.openapi.util.Key.create((String)"modifiedData");
    private static final com.intellij.openapi.util.Key<DataNodeCheckedTreeNode> CONNECTED_UI_NODE_KEY = com.intellij.openapi.util.Key.create((String)"connectedUiNode");
    @NotNull
    private final Project myProject;
    private JBLoadingPanel loadingPanel;
    private JPanel mainPanel;
    private JPanel contentPanel;
    private JBLabel myDescriptionLbl;
    private JBLabel mySelectionStatusLbl;
    private ExternalSystemUiAware myExternalSystemUiAware;
    private ExternalProjectInfo myProjectInfo;
    private final Set<Key<?>> myIgnorableKeys;
    private final Set<Key<?>> myPublicKeys;
    private final Set<Key<? extends Identifiable>> myDependencyAwareDataKeys;
    @Nullable
    private final Object myPreselectedNodeObject;
    private CheckboxTree myTree;
    private final MultiMap<DataNode<Identifiable>, DataNode<Identifiable>> dependentNodeMap;
    private final SimpleModificationTracker myModificationTracker;
    private final CachedValue<SelectionState> selectionState;
    private boolean myShowSelectedRowsOnly;
    private int myModulesCount;

    public ExternalProjectDataSelectorDialog(@NotNull Project project, @NotNull ExternalProjectInfo projectInfo) {
        if (project == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(0);
        }
        if (projectInfo == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(1);
        }
        this(project, projectInfo, null);
    }

    public ExternalProjectDataSelectorDialog(@NotNull Project project, @NotNull ExternalProjectInfo projectInfo, @Nullable Object preselectedNodeDataObject) {
        if (project == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(2);
        }
        if (projectInfo == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(3);
        }
        super(project, true);
        this.$$$setupUI$$$();
        this.dependentNodeMap = MultiMap.createIdentity();
        this.myModificationTracker = new SimpleModificationTracker();
        this.selectionState = new CachedValueImpl<SelectionState>(() -> CachedValueProvider.Result.createSingleDependency((Object)this.getSelectionStatus(), (Object)this.myModificationTracker));
        this.myProject = project;
        this.myIgnorableKeys = ExternalProjectDataSelectorDialog.getIgnorableKeys();
        this.myPublicKeys = ExternalProjectDataSelectorDialog.getPublicKeys();
        this.myDependencyAwareDataKeys = ExternalProjectDataSelectorDialog.getDependencyAwareDataKeys();
        this.myPreselectedNodeObject = preselectedNodeDataObject;
        this.init(projectInfo);
    }

    private void init(@NotNull ExternalProjectInfo projectInfo) {
        if (projectInfo == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(4);
        }
        this.myProjectInfo = projectInfo;
        this.myExternalSystemUiAware = ExternalSystemUiUtil.getUiAware(this.myProjectInfo.getProjectSystemId());
        this.myTree = this.createTree();
        this.updateSelectionState();
        this.myTree.addCheckboxTreeListener(new CheckboxTreeListener(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExternalProjectDataSelectorDialog.this.updateSelectionState();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$1", "nodeStateChanged"));
            }
        });
        String externalSystemName = this.myProjectInfo.getProjectSystemId().getReadableName();
        this.setTitle(ExternalSystemBundle.message((String)"dialog.title.project.data.to.import", (Object[])new Object[]{externalSystemName}));
        this.init();
    }

    public boolean hasMultipleDataToSelect() {
        return this.myModulesCount > 1;
    }

    private void updateSelectionState() {
        this.myModificationTracker.incModificationCount();
        this.mySelectionStatusLbl.setText(((SelectionState)this.selectionState.getValue()).message);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)this.myTree)).addExtraAction((AnActionButton)new SelectAllButton()).addExtraAction((AnActionButton)new UnselectAllButton()).addExtraAction((AnActionButton)new ShowSelectedOnlyButton()).addExtraAction((AnActionButton)new SelectRequiredButton()).setToolbarPosition(ActionToolbarPosition.BOTTOM);
        this.contentPanel.add(decorator.createPanel());
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        this.loadingPanel.add((Component)this.mainPanel, (Object)"Center");
        return this.loadingPanel;
    }

    private void reloadTree() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
        Object root = treeModel.getRoot();
        if (!(root instanceof CheckedTreeNode)) {
            return;
        }
        CheckedTreeNode rootNode = (CheckedTreeNode)root;
        Couple<CheckedTreeNode> rootAndPreselectedNode = this.createRoot();
        CheckedTreeNode rootCopy = (CheckedTreeNode)rootAndPreselectedNode.first;
        List nodes = TreeUtil.listChildren((TreeNode)rootCopy);
        rootNode.removeAllChildren();
        TreeUtil.addChildrenTo((MutableTreeNode)rootNode, (List)nodes);
        treeModel.reload();
    }

    protected void doOKAction() {
        this.loadingPanel.setLoadingText(ExternalSystemBundle.message((String)"please.wait", (Object[])new Object[0]));
        this.loadingPanel.startLoading();
        final DataNode projectStructure = this.myProjectInfo.getExternalProjectStructure();
        if (projectStructure != null) {
            boolean[] isModified = new boolean[]{false};
            projectStructure.visit(node -> {
                DataNode modifiedDataNode = (DataNode)node.getUserData(MODIFIED_NODE_KEY);
                if (modifiedDataNode != null) {
                    if (node.isIgnored() != modifiedDataNode.isIgnored()) {
                        node.setIgnored(modifiedDataNode.isIgnored());
                        isModified[0] = true;
                    }
                    node.removeUserData(MODIFIED_NODE_KEY);
                    node.removeUserData(CONNECTED_UI_NODE_KEY);
                }
            });
            if (isModified[0]) {
                DataNode notIgnoredNode = (DataNode)ContainerUtil.find((Iterable)projectStructure.getChildren(), node -> !node.isIgnored());
                projectStructure.setIgnored(notIgnoredNode == null);
                ExternalSystemUtil.invokeLater(this.myProject, ModalityState.NON_MODAL, () -> {
                    ProjectData projectData2 = (ProjectData)projectStructure.getData();
                    String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{projectData2.getExternalName(), projectData2.getOwner().getReadableName()});
                    new Task.Backgroundable(this.myProject, title, true, PerformInBackgroundOption.DEAF){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            ((ProjectDataManager)ApplicationManager.getApplication().getService(ProjectDataManager.class)).importData(projectStructure, this.myProject, false);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$2", "run"));
                        }
                    }.queue();
                });
            }
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        ExternalSystemApiUtil.visit((DataNode)this.myProjectInfo.getExternalProjectStructure(), node -> {
            node.removeUserData(MODIFIED_NODE_KEY);
            node.removeUserData(CONNECTED_UI_NODE_KEY);
        });
        super.doCancelAction();
    }

    private CheckboxTree createTree() {
        Couple<CheckedTreeNode> rootAndPreselectedNode = this.createRoot();
        CheckedTreeNode root = (CheckedTreeNode)rootAndPreselectedNode.first;
        CheckboxTree tree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(true, false){

            public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value2 instanceof DataNodeCheckedTreeNode)) {
                    return;
                }
                DataNodeCheckedTreeNode node = (DataNodeCheckedTreeNode)((Object)value2);
                String tooltip = null;
                boolean hasErrors = false;
                if (node.isChecked()) {
                    String listOfUncheckedDependencies;
                    Enumeration children2 = node.children();
                    while (children2.hasMoreElements()) {
                        Object o = children2.nextElement();
                        if (!(o instanceof DataNodeCheckedTreeNode) || ((DataNodeCheckedTreeNode)((Object)o)).isChecked()) continue;
                        this.myCheckbox.setEnabled(false);
                        break;
                    }
                    if (ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(node.myDataNode.getKey()) && StringUtil.isNotEmpty((String)(listOfUncheckedDependencies = StringUtil.join((Collection)ExternalProjectDataSelectorDialog.this.dependentNodeMap.get((Object)node.myDataNode), depNode -> {
                        DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)((Object)((Object)depNode.getUserData(CONNECTED_UI_NODE_KEY)));
                        return uiNode != null && !uiNode.isChecked() ? ((Identifiable)depNode.getData()).getId() : null;
                    }, (String)"<br>")))) {
                        hasErrors = true;
                        tooltip = ExternalSystemBundle.message((String)"there.are.not.selected.module.dependencies.of.the.module.br.b.0.b", (Object[])new Object[]{listOfUncheckedDependencies});
                    }
                }
                ColoredTreeCellRenderer renderer2 = this.getTextRenderer();
                renderer2.setIcon(node.icon);
                renderer2.append(node.text, hasErrors ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (!StringUtil.isEmptyOrSpaces((String)node.comment)) {
                    Object description = node.comment;
                    if (node.comment.length() > 50) {
                        description = node.comment.substring(0, 50) + "...";
                    }
                    renderer2.append(" (" + (String)description + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.setToolTipText(StringUtil.isEmpty(tooltip) ? node.comment : tooltip);
                } else {
                    this.setToolTipText(StringUtil.isNotEmpty(tooltip) ? tooltip : null);
                }
            }
        }, root, new CheckboxTreeBase.CheckPolicy(true, true, false, false));
        TreeUtil.expand((JTree)((Object)tree), (int)1);
        if (rootAndPreselectedNode.second != null) {
            TreeUtil.selectNode((JTree)((Object)tree), (TreeNode)((TreeNode)rootAndPreselectedNode.second));
        } else {
            tree.setSelectionRow(0);
        }
        return tree;
    }

    private Couple<CheckedTreeNode> createRoot() {
        IdentityHashMap treeNodeMap = new IdentityHashMap();
        TreeMap ideGroupingMap = new TreeMap();
        DataNodeCheckedTreeNode[] preselectedNode = new DataNodeCheckedTreeNode[]{null};
        DataNodeCheckedTreeNode[] rootModuleNode = new DataNodeCheckedTreeNode[]{null};
        MultiMap moduleDependenciesMap = MultiMap.create();
        HashMap modulesNodeMap = new HashMap();
        for (Object moduleDependencyDataNode : ExternalSystemApiUtil.findAllRecursively((DataNode)this.myProjectInfo.getExternalProjectStructure(), (Key)ProjectKeys.MODULE_DEPENDENCY)) {
            ModuleDependencyData moduleDependencyData = (ModuleDependencyData)moduleDependencyDataNode.getData();
            moduleDependenciesMap.putValue((Object)moduleDependencyData.getOwnerModule().getId(), (Object)((ModuleData)moduleDependencyData.getTarget()).getId());
        }
        int[] modulesCount = new int[]{0};
        ExternalSystemApiUtil.visit((DataNode)this.myProjectInfo.getExternalProjectStructure(), node -> {
            Key key = node.getKey();
            if (!this.myPublicKeys.contains(key)) {
                return;
            }
            DataNode modifiableDataNode = ExternalProjectDataSelectorDialog.getModifiableDataNode(node);
            if (this.myDependencyAwareDataKeys.contains(key)) {
                modulesCount[0] = modulesCount[0] + 1;
            }
            if (modifiableDataNode.isIgnored() && this.myShowSelectedRowsOnly) {
                return;
            }
            DataNodeCheckedTreeNode treeNode = (DataNodeCheckedTreeNode)((Object)((Object)((Object)treeNodeMap.get(node))));
            if (treeNode == null) {
                Identifiable moduleData;
                treeNode = new DataNodeCheckedTreeNode((DataNode)node);
                if (this.myDependencyAwareDataKeys.contains(key)) {
                    moduleData = (Identifiable)node.getData();
                    modulesNodeMap.put(moduleData.getId(), node);
                }
                if (this.myPreselectedNodeObject != null && this.myPreselectedNodeObject.equals(node.getData())) {
                    preselectedNode[0] = treeNode;
                }
                if (node.getData() instanceof ModuleData) {
                    String ideGrouping;
                    moduleData = (ModuleData)node.getData();
                    if (key.equals((Object)ProjectKeys.MODULE) && this.myProjectInfo.getExternalProjectPath().equals(moduleData.getLinkedExternalProjectPath())) {
                        rootModuleNode[0] = treeNode;
                    }
                    if ((ideGrouping = moduleData.getIdeGrouping()) != null) {
                        ideGroupingMap.put(ideGrouping, node);
                    }
                } else {
                    DataNodeCheckedTreeNode moduleTreeNode;
                    DataNode parentModule = node.getParent(ModuleData.class);
                    if (parentModule != null && (moduleTreeNode = (DataNodeCheckedTreeNode)((Object)((Object)((Object)treeNodeMap.get(parentModule))))) != null) {
                        moduleTreeNode.add((MutableTreeNode)((Object)treeNode));
                        treeNode.setParent((MutableTreeNode)((Object)moduleTreeNode));
                    }
                }
                treeNode.setEnabled(this.myIgnorableKeys.contains(key));
                treeNodeMap.put(node, treeNode);
            }
        });
        for (Map.Entry entry : ideGroupingMap.entrySet()) {
            DataNode node2 = (DataNode)entry.getValue();
            if (!(node2.getData() instanceof ModuleData)) continue;
            ModuleData moduleData = (ModuleData)node2.getData();
            String ideParentGrouping = moduleData.getIdeParentGrouping();
            DataNode structuralParent = ideParentGrouping != null ? (DataNode)ideGroupingMap.get(ideParentGrouping) : null;
            DataNodeCheckedTreeNode treeParentNode = structuralParent != null ? (DataNodeCheckedTreeNode)((Object)treeNodeMap.get(structuralParent)) : null;
            DataNodeCheckedTreeNode treeNode = (DataNodeCheckedTreeNode)((Object)treeNodeMap.get(node2));
            if (treeParentNode == null) {
                treeParentNode = (DataNodeCheckedTreeNode)((Object)treeNodeMap.get(node2.getParent()));
            }
            if (treeNode == null || treeParentNode == null) continue;
            treeParentNode.add((MutableTreeNode)((Object)treeNode));
            treeNode.setParent((MutableTreeNode)((Object)treeParentNode));
        }
        this.myModulesCount = modulesCount[0];
        this.dependentNodeMap.clear();
        for (String string : moduleDependenciesMap.keySet()) {
            Collection moduleDependencies = moduleDependenciesMap.get((Object)string);
            DataNode moduleNode = (DataNode)modulesNodeMap.get(string);
            if (moduleNode == null) continue;
            this.dependentNodeMap.putValues((Object)moduleNode, (Collection)ContainerUtil.mapNotNull((Collection)moduleDependencies, modulesNodeMap::get));
        }
        CheckedTreeNode root = new CheckedTreeNode(null);
        DataNodeCheckedTreeNode dataNodeCheckedTreeNode = (DataNodeCheckedTreeNode)((Object)treeNodeMap.get(this.myProjectInfo.getExternalProjectStructure()));
        String rootModuleComment = "root module";
        if (rootModuleNode[0] != null && dataNodeCheckedTreeNode != null) {
            rootModuleNode[0].comment = rootModuleComment;
            if (!dataNodeCheckedTreeNode.isNodeChild((TreeNode)((Object)rootModuleNode[0]))) {
                dataNodeCheckedTreeNode.add((MutableTreeNode)((Object)rootModuleNode[0]));
            }
        }
        List nodes = dataNodeCheckedTreeNode != null ? TreeUtil.listChildren((TreeNode)((Object)dataNodeCheckedTreeNode)) : ContainerUtil.emptyList();
        nodes.sort((o1, o2) -> {
            if (o1 instanceof DataNodeCheckedTreeNode && o2 instanceof DataNodeCheckedTreeNode) {
                if (rootModuleComment.equals(((DataNodeCheckedTreeNode)((Object)((Object)((Object)o1)))).comment)) {
                    return -1;
                }
                if (rootModuleComment.equals(((DataNodeCheckedTreeNode)((Object)((Object)((Object)o2)))).comment)) {
                    return 1;
                }
                return StringUtil.naturalCompare((String)((DataNodeCheckedTreeNode)((Object)((Object)((Object)o1)))).text, (String)((DataNodeCheckedTreeNode)((Object)((Object)((Object)o2)))).text);
            }
            return 0;
        });
        TreeUtil.addChildrenTo((MutableTreeNode)root, (List)nodes);
        return Couple.of((Object)root, (Object)((Object)preselectedNode[0]));
    }

    @NotNull
    private static Set<Key<?>> getPublicKeys() {
        HashSet result2 = new HashSet(DATA_KEYS);
        for (ExternalProjectStructureCustomizer customizer : (ExternalProjectStructureCustomizer[])ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            result2.addAll(customizer.getPublicDataKeys());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    private static Set<Key<?>> getIgnorableKeys() {
        HashSet result2 = new HashSet(DATA_KEYS);
        for (ExternalProjectStructureCustomizer customizer : (ExternalProjectStructureCustomizer[])ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            result2.addAll(customizer.getIgnorableDataKeys());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    private static Set<Key<? extends Identifiable>> getDependencyAwareDataKeys() {
        HashSet<Key<? extends Identifiable>> result2 = new HashSet<Key<? extends Identifiable>>();
        result2.add(ProjectKeys.MODULE);
        for (ExternalProjectStructureCustomizer customizer : (ExternalProjectStructureCustomizer[])ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            result2.addAll(customizer.getDependencyAwareDataKeys());
        }
        HashSet<Key<? extends Identifiable>> hashSet = result2;
        if (hashSet == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    private static DataNode getModifiableDataNode(@NotNull DataNode node) {
        DataNode modifiedDataNode;
        if (node == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(8);
        }
        if ((modifiedDataNode = (DataNode)node.getUserData(MODIFIED_NODE_KEY)) == null) {
            modifiedDataNode = node.nodeCopy();
            node.putUserData(MODIFIED_NODE_KEY, (Object)modifiedDataNode);
        }
        DataNode dataNode = modifiedDataNode;
        if (dataNode == null) {
            ExternalProjectDataSelectorDialog.$$$reportNull$$$0(9);
        }
        return dataNode;
    }

    private SelectionState getSelectionStatus() {
        boolean isRequiredSelectionEnabled = this.computeRequiredSelectionStatus();
        String stateMessage = "";
        Object root = this.myTree.getModel().getRoot();
        if (root instanceof CheckedTreeNode) {
            int[] selectedModulesCount = new int[]{0};
            TreeUtil.traverse((TreeNode)((CheckedTreeNode)root), node -> {
                if (node instanceof DataNodeCheckedTreeNode && ((DataNodeCheckedTreeNode)((Object)((Object)node))).isChecked() && this.myDependencyAwareDataKeys.contains(((DataNodeCheckedTreeNode)((Object)((Object)node))).myDataNode.getKey())) {
                    selectedModulesCount[0] = selectedModulesCount[0] + 1;
                }
                return true;
            });
            stateMessage = ExternalSystemBundle.message((String)"label.modules.selected", (Object[])new Object[]{this.myModulesCount, selectedModulesCount[0]});
        }
        return new SelectionState(isRequiredSelectionEnabled, stateMessage);
    }

    private boolean computeRequiredSelectionStatus() {
        for (DataNode node : this.dependentNodeMap.keySet()) {
            DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)((Object)node.getUserData(CONNECTED_UI_NODE_KEY));
            assert (uiNode != null);
            if (!uiNode.isChecked()) continue;
            for (DataNode depNode : this.dependentNodeMap.get((Object)node)) {
                DataNodeCheckedTreeNode uiDependentNode = (DataNodeCheckedTreeNode)((Object)depNode.getUserData(CONNECTED_UI_NODE_KEY));
                assert (uiDependentNode != null);
                if (uiDependentNode.isChecked()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean showAndGet() {
        BooleanValueHolder result2 = new BooleanValueHolder(false);
        DumbService.getInstance((Project)this.myProject).suspendIndexingAndRun(ExternalSystemBundle.message((String)"activity.name.select.external.data", (Object[])new Object[0]), () -> result2.setValue(super.showAndGet()));
        return result2.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnorableKeys";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyAwareDataKeys";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableDataNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableDataNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.mainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        ((Component)jPanel3).setEnabled(true);
        jPanel3.setMinimumSize(new Dimension(300, 100));
        jPanel3.setOpaque(false);
        jPanel3.setPreferredSize(new Dimension(400, 300));
        this.contentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setAutoscrolls(true);
        jPanel2.setMinimumSize(new Dimension(0, 0));
        jPanel2.setPreferredSize(new Dimension(0, 0));
        jPanel3.add((Component)jPanel2, "Center");
        this.mySelectionStatusLbl = jBLabel2 = new JBLabel();
        jPanel2.add((Component)jBLabel2, "South");
        this.myDescriptionLbl = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/ExternalSystemBundle", ExternalProjectDataSelectorDialog.class).getString("label.please.select.the.modules.data.to.include.in.the.project"));
        jPanel3.add((Component)jBLabel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class SelectRequiredButton
    extends AnActionButton {
        SelectRequiredButton() {
            super(ExternalSystemBundle.message((String)"select.required", (Object[])new Object[0]), ExternalSystemBundle.message((String)"select.modules.depended.on.currently.selected.modules", (Object[])new Object[0]), AllIcons.Actions.IntentionBulb);
            this.addCustomUpdater(e -> ((SelectionState)ExternalProjectDataSelectorDialog.this.selectionState.getValue()).isRequiredSelectionEnabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean showSelectedRowsOnly;
            if (e == null) {
                SelectRequiredButton.$$$reportNull$$$0(0);
            }
            if (showSelectedRowsOnly = ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = false;
                ExternalProjectDataSelectorDialog.this.reloadTree();
            }
            ExternalProjectDataSelectorDialog.this.myTree.clearSelection();
            for (DataNode node : ExternalProjectDataSelectorDialog.this.dependentNodeMap.keySet()) {
                DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)((Object)node.getUserData(CONNECTED_UI_NODE_KEY));
                assert (uiNode != null);
                if (!uiNode.isChecked()) continue;
                for (DataNode treeNode : ExternalProjectDataSelectorDialog.this.dependentNodeMap.get((Object)node)) {
                    DataNodeCheckedTreeNode uiDependentNode = (DataNodeCheckedTreeNode)((Object)treeNode.getUserData(CONNECTED_UI_NODE_KEY));
                    assert (uiDependentNode != null);
                    ExternalProjectDataSelectorDialog.this.myTree.setNodeState(uiDependentNode, true);
                }
            }
            if (showSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = true;
                ExternalProjectDataSelectorDialog.this.reloadTree();
            }
            ExternalProjectDataSelectorDialog.this.updateSelectionState();
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$SelectRequiredButton", "actionPerformed"));
        }
    }

    private class ShowSelectedOnlyButton
    extends ToggleActionButton {
        ShowSelectedOnlyButton() {
            super(ExternalSystemBundle.messagePointer((String)"show.selected.only", (Object[])new Object[0]), AllIcons.Actions.ShowHiddens);
        }

        public boolean isSelected(AnActionEvent e) {
            return ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = state;
            ExternalProjectDataSelectorDialog.this.reloadTree();
        }
    }

    private class UnselectAllButton
    extends AnActionButton {
        UnselectAllButton() {
            super(ExternalSystemBundle.messagePointer((String)"action.text.unselect.all", (Object[])new Object[0]), AllIcons.Actions.Unselectall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DefaultTreeModel treeModel;
            Object root;
            if (e == null) {
                UnselectAllButton.$$$reportNull$$$0(0);
            }
            if (!((root = (treeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.myTree.getModel()).getRoot()) instanceof CheckedTreeNode)) {
                return;
            }
            if (!ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, false);
            } else {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = false;
                ExternalProjectDataSelectorDialog.this.reloadTree();
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, false);
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = true;
                ExternalProjectDataSelectorDialog.this.reloadTree();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$UnselectAllButton", "actionPerformed"));
        }
    }

    private class SelectAllButton
    extends AnActionButton {
        SelectAllButton() {
            super(ExternalSystemBundle.messagePointer((String)"action.text.select.all", (Object[])new Object[0]), AllIcons.Actions.Selectall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            TreeModel treeModel;
            Object root;
            if (e == null) {
                SelectAllButton.$$$reportNull$$$0(0);
            }
            if (!((root = (treeModel = ExternalProjectDataSelectorDialog.this.myTree.getModel()).getRoot()) instanceof CheckedTreeNode)) {
                return;
            }
            if (!ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, true);
            } else {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = false;
                ExternalProjectDataSelectorDialog.this.reloadTree();
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, true);
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$SelectAllButton", "actionPerformed"));
        }
    }

    private static class SelectionState {
        boolean isRequiredSelectionEnabled;
        @Nullable
        String message;

        SelectionState(boolean isRequiredSelectionEnabled, @Nullable @NlsContexts.Label String message) {
            this.isRequiredSelectionEnabled = isRequiredSelectionEnabled;
            this.message = message;
        }
    }

    private final class DataNodeCheckedTreeNode
    extends CheckedTreeNode {
        private static final int MAX_DEPENDENCIES_TO_DESCRIBE = 5;
        private final DataNode myDataNode;
        @Nullable
        private final Icon icon;
        private String text;
        @Nullable
        private String comment;

        private DataNodeCheckedTreeNode(DataNode node) {
            super((Object)node);
            this.myDataNode = node;
            node.putUserData(CONNECTED_UI_NODE_KEY, (Object)this);
            DataNode modifiableDataNode = (DataNode)node.getUserData(MODIFIED_NODE_KEY);
            assert (modifiableDataNode != null);
            this.isChecked = !modifiableDataNode.isIgnored();
            Icon anIconCandidate = null;
            boolean multipleIconCandidatesFound = false;
            ExternalProjectStructureCustomizer projectStructureCustomizer = new ExternalProjectStructureCustomizerImpl();
            for (ExternalProjectStructureCustomizer customizer : (ExternalProjectStructureCustomizer[])ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
                Icon icon2 = customizer.suggestIcon(node, ExternalProjectDataSelectorDialog.this.myExternalSystemUiAware);
                if (!multipleIconCandidatesFound && icon2 != null) {
                    if (anIconCandidate != null) {
                        multipleIconCandidatesFound = true;
                        anIconCandidate = null;
                    } else {
                        anIconCandidate = icon2;
                    }
                }
                if (!customizer.getPublicDataKeys().contains(node.getKey())) continue;
                projectStructureCustomizer = customizer;
                break;
            }
            this.icon = anIconCandidate != null ? anIconCandidate : ((ExternalProjectStructureCustomizer)projectStructureCustomizer).suggestIcon(node, ExternalProjectDataSelectorDialog.this.myExternalSystemUiAware);
            Couple<String> representationName = ((ExternalProjectStructureCustomizer)projectStructureCustomizer).getRepresentationName(node);
            this.text = (String)representationName.first;
            this.comment = (String)representationName.second;
            if (this.text == null) {
                this.text = node.getKey().toString();
            }
        }

        public void setChecked(boolean checked) {
            DataNodeCheckedTreeNode[] unprocessedNodes;
            super.setChecked(checked);
            if (checked) {
                DataNodeCheckedTreeNode parent = this;
                DataNodeCheckedTreeNode moduleNode = null;
                while (parent.parent instanceof DataNodeCheckedTreeNode) {
                    if (moduleNode == null && ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(parent.myDataNode.getKey())) {
                        moduleNode = parent;
                    }
                    parent = (DataNodeCheckedTreeNode)((Object)parent.parent);
                }
                parent.isChecked = true;
                DataNode modifiedParentDataNode = ExternalProjectDataSelectorDialog.getModifiableDataNode(parent.myDataNode);
                modifiedParentDataNode.setIgnored(false);
                if (moduleNode != null) {
                    moduleNode.isChecked = true;
                }
                ExternalSystemApiUtil.visit((DataNode)(moduleNode == null ? this.myDataNode : moduleNode.myDataNode), node -> ExternalProjectDataSelectorDialog.getModifiableDataNode(node).setIgnored(false));
            } else {
                ExternalSystemApiUtil.visit((DataNode)this.myDataNode, node -> ExternalProjectDataSelectorDialog.getModifiableDataNode(node).setIgnored(true));
                if (ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                    DefaultTreeModel treeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.myTree.getModel();
                    TreePath[] before = ExternalProjectDataSelectorDialog.this.myTree.getSelectionPaths();
                    treeModel.removeNodeFromParent((MutableTreeNode)((Object)this));
                    ExternalProjectDataSelectorDialog.this.myTree.addSelectionPaths(before);
                }
            }
            if (!checked && this.parent instanceof DataNodeCheckedTreeNode && this.myDataNode.getKey().equals((Object)ProjectKeys.MODULE) && ((DataNodeCheckedTreeNode)((Object)this.parent)).myDataNode.getKey().equals((Object)ProjectKeys.PROJECT)) {
                DataNode projectDataNode = ((DataNodeCheckedTreeNode)((Object)this.parent)).myDataNode;
                ProjectData projectData2 = (ProjectData)projectDataNode.getData();
                ModuleData moduleData = (ModuleData)this.myDataNode.getData();
                if (moduleData.getLinkedExternalProjectPath().equals(projectData2.getLinkedExternalProjectPath()) && ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE).size() == 1) {
                    ((DataNodeCheckedTreeNode)((Object)this.parent)).setChecked(false);
                }
            }
            boolean isCheckCompleted = (unprocessedNodes = (DataNodeCheckedTreeNode[])ExternalProjectDataSelectorDialog.this.myTree.getSelectedNodes(DataNodeCheckedTreeNode.class, node -> ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(node.myDataNode.getKey()) && checked != node.isChecked())).length == 0 && ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(this.myDataNode.getKey());
            ExternalProjectDataSelectorDialog.this.updateSelectionState();
            if (((SelectionState)ExternalProjectDataSelectorDialog.this.selectionState.getValue()).isRequiredSelectionEnabled && isCheckCompleted) {
                this.warnAboutMissedDependencies(checked);
            }
        }

        private void warnAboutMissedDependencies(boolean checked) {
            String message;
            SmartList selectedModules = new SmartList();
            for (Object node2 : TreeUtil.collectSelectedObjectsOfType((JTree)((Object)ExternalProjectDataSelectorDialog.this.myTree), DataNode.class)) {
                if (!ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(node2.getKey())) continue;
                selectedModules.add(node2);
            }
            HashSet<DataNode> deps = new HashSet<DataNode>();
            for (DataNode selectedModule : selectedModules) {
                if (checked) {
                    deps.addAll(ContainerUtil.filter((Collection)ExternalProjectDataSelectorDialog.this.dependentNodeMap.get((Object)selectedModule), node -> {
                        DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)((Object)((Object)node.getUserData(CONNECTED_UI_NODE_KEY)));
                        return uiNode != null && !uiNode.isChecked();
                    }));
                    continue;
                }
                for (Object node3 : ExternalProjectDataSelectorDialog.this.dependentNodeMap.keySet()) {
                    Collection dependencies;
                    DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)((Object)node3.getUserData(CONNECTED_UI_NODE_KEY));
                    if (uiNode != null && !uiNode.isChecked() || !(dependencies = ExternalProjectDataSelectorDialog.this.dependentNodeMap.get(node3)).contains(selectedModule)) continue;
                    deps.add((DataNode)node3);
                }
            }
            if (!deps.isEmpty() && Messages.showOkCancelDialog((String)(message = checked ? this.getEnableMessage((List<? extends DataNode<Identifiable>>)selectedModules, deps) : this.getDisableMessage(deps)), (String)(checked ? ExternalSystemBundle.message((String)"enable.dependant.modules", (Object[])new Object[0]) : ExternalSystemBundle.message((String)"disable.modules.with.dependency.on.this", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon()) == 0) {
                List nodes = ContainerUtil.mapNotNull(deps, node -> (DataNodeCheckedTreeNode)((Object)((Object)node.getUserData(CONNECTED_UI_NODE_KEY))));
                for (Object node3 : nodes) {
                    DefaultTreeModel treeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.myTree.getModel();
                    ExternalProjectDataSelectorDialog.this.myTree.addSelectionPath(new TreePath(treeModel.getPathToRoot((TreeNode)node3)));
                }
                for (Object node3 : nodes) {
                    ((DataNodeCheckedTreeNode)((Object)node3)).setChecked(checked);
                }
            }
        }

        private String getEnableMessage(List<? extends DataNode<Identifiable>> selectedModules, Set<? extends DataNode<Identifiable>> deps) {
            if (deps.size() > 5 || selectedModules.size() > 5) {
                return String.format("%d disabled %s depend on %d selected %s. Would you like to enable %s too?", deps.size(), StringUtil.pluralize((String)"module", (int)deps.size()), selectedModules.size(), StringUtil.pluralize((String)"module", (int)selectedModules.size()), deps.size() == 1 ? "it" : "them");
            }
            String listOfSelectedModules = StringUtil.join(selectedModules, node -> ((Identifiable)node.getData()).getId(), (String)", ");
            String listOfDependencies = StringUtil.join(deps, node -> ((Identifiable)node.getData()).getId(), (String)"<br>");
            return String.format("<html>The following %s on which <b>%s</b> %s %s disabled:<br><b>%s</b><br>Would you like to enable %s?</html>", StringUtil.pluralize((String)"module", (int)deps.size()), listOfSelectedModules, StringUtil.pluralize((String)"depend", (int)selectedModules.size()), deps.size() == 1 ? "is" : "are", listOfDependencies, deps.size() == 1 ? "it" : "them");
        }

        private String getDisableMessage(Set<? extends DataNode<Identifiable>> deps) {
            if (deps.size() > 5) {
                return String.format("%d enabled modules depend on selected modules. Would you like to disable them too?", deps.size());
            }
            String listOfDependencies = StringUtil.join(deps, node -> ((Identifiable)node.getData()).getId(), (String)"<br>");
            return String.format("<html>The following %s <br><b>%s</b><br>%s enabled and %s on selected modules. <br>Would you like to disable %s too?</html>", StringUtil.pluralize((String)"module", (int)deps.size()), listOfDependencies, deps.size() == 1 ? "is" : "are", StringUtil.pluralize((String)"depend", (int)deps.size()), deps.size() == 1 ? "it" : "them");
        }
    }
}

