/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildView;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.testframework.HistoryTestRunnableState;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\r\u0010\u0012\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskRunner;", "Lcom/intellij/execution/runners/ProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "doExecute", "Lcom/intellij/execution/ui/RunContentDescriptor;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "execute", "", "getRunnerId", "Lorg/jetbrains/annotations/NotNull;", "Companion", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemTaskRunner
implements ProgramRunner<RunnerSettings> {
    @NotNull
    private static final Key<String> TOOL_WINDOW_ID_KEY;
    public static final Companion Companion;

    @NotNull
    public String getRunnerId() {
        return "ExternalSystemTaskRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile instanceof ExternalSystemRunConfiguration && Intrinsics.areEqual((Object)"Run", (Object)executorId);
    }

    public void execute(@NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfileState runProfileState = environment.getState();
        if (runProfileState == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)runProfileState, (String)"environment.state ?: return");
        RunProfileState state = runProfileState;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"environment.project");
        ExecutionManager.Companion.getInstance(project).startRunProfile(environment, (Function0)new Function0<Promise<RunContentDescriptor>>(this, state, environment){
            final /* synthetic */ ExternalSystemTaskRunner this$0;
            final /* synthetic */ RunProfileState $state;
            final /* synthetic */ ExecutionEnvironment $environment;

            @NotNull
            public final Promise<RunContentDescriptor> invoke() {
                return Promises.resolvedPromise((Object)ExternalSystemTaskRunner.access$doExecute(this.this$0, this.$state, this.$environment));
            }
            {
                this.this$0 = externalSystemTaskRunner;
                this.$state = runProfileState;
                this.$environment = executionEnvironment;
                super(0);
            }
        });
    }

    private final RunContentDescriptor doExecute(RunProfileState state, ExecutionEnvironment environment) {
        if (!(state instanceof ExternalSystemRunnableState) && !(state instanceof HistoryTestRunnableState)) {
            return null;
        }
        ExecutionResult executionResult = state.execute(environment.getExecutor(), (ProgramRunner)this);
        if (executionResult == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"state.execute(environmen\u2026tor, this) ?: return null");
        ExecutionResult executionResult2 = executionResult;
        RunContentDescriptor runContentDescriptor = new RunContentBuilder(executionResult2, environment).showRunContent(environment.getContentToReuse());
        if (runContentDescriptor == null) {
            return null;
        }
        RunContentDescriptor runContentDescriptor2 = runContentDescriptor;
        if (state instanceof UserDataHolder) {
            String string = (String)((UserDataHolder)state).getUserData(TOOL_WINDOW_ID_KEY);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String id2 = string2;
                boolean bl3 = false;
                runContentDescriptor2.setContentToolWindowId(id2);
            }
        }
        if (state instanceof HistoryTestRunnableState) {
            return runContentDescriptor2;
        }
        ((ExternalSystemRunnableState)state).setContentDescriptor(runContentDescriptor2);
        if (executionResult2.getExecutionConsole() instanceof BuildView) {
            return runContentDescriptor2;
        }
        RunContentDescriptor descriptor2 = new RunContentDescriptor(runContentDescriptor2, runContentDescriptor2.getExecutionConsole(), runContentDescriptor2.getProcessHandler(), runContentDescriptor2.getComponent(), runContentDescriptor2.getDisplayName(), runContentDescriptor2.getIcon(), null, runContentDescriptor2.getRestartActions()){
            final /* synthetic */ RunContentDescriptor $runContentDescriptor;

            public boolean isHiddenContent() {
                return true;
            }
            {
                this.$runContentDescriptor = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
        descriptor2.setRunnerLayoutUi(runContentDescriptor2.getRunnerLayoutUi());
        return descriptor2;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)(ExternalSystemTaskRunner.class.getName() + ".TOOL_WINDOW_ID"));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(ExternalSyste\u2026name + \".TOOL_WINDOW_ID\")");
        TOOL_WINDOW_ID_KEY = key;
    }

    public static final /* synthetic */ RunContentDescriptor access$doExecute(ExternalSystemTaskRunner $this, RunProfileState state, ExecutionEnvironment environment) {
        return $this.doExecute(state, environment);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskRunner$Companion;", "", "()V", "TOOL_WINDOW_ID_KEY", "Lcom/intellij/openapi/util/Key;", "", "getTOOL_WINDOW_ID_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        public final Key<String> getTOOL_WINDOW_ID_KEY() {
            return TOOL_WINDOW_ID_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

