/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.PersistentRangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterTree;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.BitUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkupModelImpl
extends UserDataHolderBase
implements MarkupModelEx {
    private static final Logger LOG = Logger.getInstance(MarkupModelImpl.class);
    private final DocumentEx myDocument;
    private RangeHighlighter[] myCachedHighlighters;
    private final List<MarkupModelListener> myListeners;
    private final RangeHighlighterTree myHighlighterTree;
    private final RangeHighlighterTree myHighlighterTreeForLines;

    MarkupModelImpl(@NotNull DocumentEx document) {
        if (document == null) {
            MarkupModelImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDocument = document;
        this.myHighlighterTree = new RangeHighlighterTree(document, this);
        this.myHighlighterTreeForLines = new RangeHighlighterTree(document, this);
    }

    @Override
    public void dispose() {
        this.myHighlighterTree.dispose(this.myDocument);
        this.myHighlighterTreeForLines.dispose(this.myDocument);
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int line, int layer, @Nullable TextAttributes textAttributes) {
        RangeHighlighter rangeHighlighter = this.addLineHighlighter(null, textAttributes, line, layer);
        if (rangeHighlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(1);
        }
        return rangeHighlighter;
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(@Nullable TextAttributesKey textAttributesKey, int lineNumber, int layer) {
        RangeHighlighter rangeHighlighter = this.addLineHighlighter(textAttributesKey, null, lineNumber, layer);
        if (rangeHighlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(2);
        }
        return rangeHighlighter;
    }

    private RangeHighlighter addLineHighlighter(@Nullable TextAttributesKey textAttributesKey, @Nullable TextAttributes textAttributes, int lineNumber, int layer) {
        if (this.isNotValidLine(lineNumber)) {
            throw new IndexOutOfBoundsException("lineNumber:" + lineNumber + ". Must be in [0, " + (this.getDocument().getLineCount() - 1) + "]");
        }
        int offset = DocumentUtil.getFirstNonSpaceCharOffset(this.getDocument(), lineNumber);
        HighlighterTargetArea area = HighlighterTargetArea.LINES_IN_RANGE;
        Consumer changeAction = textAttributes == null ? null : ex -> ex.setTextAttributes(textAttributes);
        return this.addRangeHighlighterAndChangeAttributes(textAttributesKey, offset, offset, layer, area, false, (Consumer<? super RangeHighlighterEx>)changeAction);
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(@Nullable TextAttributesKey textAttributesKey, int lineNumber, int layer) {
        return this.addPersistentLineHighlighter(textAttributesKey, null, lineNumber, layer);
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(int lineNumber, int layer, @Nullable TextAttributes textAttributes) {
        return this.addPersistentLineHighlighter(null, textAttributes, lineNumber, layer);
    }

    @Nullable
    private RangeHighlighterEx addPersistentLineHighlighter(@Nullable TextAttributesKey textAttributesKey, @Nullable TextAttributes textAttributes, int lineNumber, int layer) {
        if (this.isNotValidLine(lineNumber)) {
            return null;
        }
        int offset = DocumentUtil.getFirstNonSpaceCharOffset(this.getDocument(), lineNumber);
        Consumer changeAction = textAttributes == null ? null : ex -> ex.setTextAttributes(textAttributes);
        return this.addRangeHighlighter(PersistentRangeHighlighterImpl.create(this, offset, layer, HighlighterTargetArea.LINES_IN_RANGE, textAttributesKey, false), (Consumer<? super RangeHighlighterEx>)changeAction);
    }

    private boolean isNotValidLine(int lineNumber) {
        return lineNumber >= this.getDocument().getLineCount() || lineNumber < 0;
    }

    public RangeHighlighter @NotNull [] getAllHighlighters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCachedHighlighters == null) {
            int size = this.myHighlighterTree.size() + this.myHighlighterTreeForLines.size();
            if (size == 0) {
                if (RangeHighlighter.EMPTY_ARRAY == null) {
                    MarkupModelImpl.$$$reportNull$$$0(3);
                }
                return RangeHighlighter.EMPTY_ARRAY;
            }
            ArrayList list2 = new ArrayList(size);
            CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor(list2);
            this.myHighlighterTree.processAll(collectProcessor);
            this.myHighlighterTreeForLines.processAll(collectProcessor);
            this.myCachedHighlighters = list2.toArray(RangeHighlighter.EMPTY_ARRAY);
        }
        if (this.myCachedHighlighters == null) {
            MarkupModelImpl.$$$reportNull$$$0(4);
        }
        return this.myCachedHighlighters;
    }

    @Override
    @NotNull
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(@Nullable TextAttributesKey textAttributesKey, int startOffset, int endOffset, int layer, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, @Nullable Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        if (targetArea == null) {
            MarkupModelImpl.$$$reportNull$$$0(5);
        }
        return this.addRangeHighlighter(isPersistent ? PersistentRangeHighlighterImpl.create(this, startOffset, layer, targetArea, textAttributesKey, true) : new RangeHighlighterImpl(this, startOffset, endOffset, layer, targetArea, textAttributesKey, false, false), changeAttributesAction);
    }

    @NotNull
    private RangeHighlighterEx addRangeHighlighter(@NotNull RangeHighlighterImpl highlighter, @Nullable Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCachedHighlighters = null;
        if (changeAttributesAction != null) {
            highlighter.changeAttributesNoEvents(changeAttributesAction);
        }
        this.fireAfterAdded(highlighter);
        RangeHighlighterImpl rangeHighlighterImpl = highlighter;
        if (rangeHighlighterImpl == null) {
            MarkupModelImpl.$$$reportNull$$$0(7);
        }
        return rangeHighlighterImpl;
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter, @NotNull Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(8);
        }
        if (changeAttributesAction == null) {
            MarkupModelImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        byte changeStatus = ((RangeHighlighterImpl)highlighter).changeAttributesNoEvents(changeAttributesAction);
        if (BitUtil.isSet((byte)changeStatus, (byte)16)) {
            this.fireAttributesChanged(highlighter, BitUtil.isSet((byte)changeStatus, (byte)32), BitUtil.isSet((byte)changeStatus, (byte)64));
        }
    }

    @Override
    public void addRangeHighlighter(@NotNull RangeHighlighterEx marker, int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (marker == null) {
            MarkupModelImpl.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.treeFor(marker).addInterval(marker, start2, end, greedyToLeft, greedyToRight, false, layer);
    }

    RangeHighlighterTree treeFor(RangeHighlighter marker) {
        return marker.getTargetArea() == HighlighterTargetArea.EXACT_RANGE ? this.myHighlighterTree : this.myHighlighterTreeForLines;
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(@Nullable TextAttributesKey textAttributesKey, int startOffset, int endOffset, int layer, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            MarkupModelImpl.$$$reportNull$$$0(11);
        }
        RangeHighlighterEx rangeHighlighterEx = this.addRangeHighlighterAndChangeAttributes(textAttributesKey, startOffset, endOffset, layer, targetArea, false, null);
        if (rangeHighlighterEx == null) {
            MarkupModelImpl.$$$reportNull$$$0(12);
        }
        return rangeHighlighterEx;
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, @Nullable TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            MarkupModelImpl.$$$reportNull$$$0(13);
        }
        Consumer changeAction = textAttributes == null ? null : ex -> ex.setTextAttributes(textAttributes);
        RangeHighlighterEx rangeHighlighterEx = this.addRangeHighlighterAndChangeAttributes(null, startOffset, endOffset, layer, targetArea, false, (Consumer<? super RangeHighlighterEx>)changeAction);
        if (rangeHighlighterEx == null) {
            MarkupModelImpl.$$$reportNull$$$0(14);
        }
        return rangeHighlighterEx;
    }

    public void removeHighlighter(@NotNull RangeHighlighter segmentHighlighter) {
        if (segmentHighlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCachedHighlighters = null;
        if (!segmentHighlighter.isValid()) {
            return;
        }
        boolean removed = this.treeFor(segmentHighlighter).removeInterval((RangeHighlighterEx)segmentHighlighter);
        LOG.assertTrue(removed);
    }

    public void removeAllHighlighters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (RangeHighlighter highlighter : this.getAllHighlighters()) {
            highlighter.dispose();
        }
        this.myCachedHighlighters = null;
        this.myHighlighterTree.clear();
        this.myHighlighterTreeForLines.clear();
    }

    @NotNull
    public Document getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            MarkupModelImpl.$$$reportNull$$$0(16);
        }
        return documentEx;
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, @NotNull MarkupModelListener listener2) {
        if (parentDisposable == null) {
            MarkupModelImpl.$$$reportNull$$$0(17);
        }
        if (listener2 == null) {
            MarkupModelImpl.$$$reportNull$$$0(18);
        }
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeMarkupModelListener(listener2));
    }

    private void removeMarkupModelListener(@NotNull MarkupModelListener listener2) {
        if (listener2 == null) {
            MarkupModelImpl.$$$reportNull$$$0(19);
        }
        boolean success = this.myListeners.remove(listener2);
        LOG.assertTrue(success);
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter, @NotNull TextAttributes textAttributes) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(20);
        }
        if (textAttributes == null) {
            MarkupModelImpl.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((RangeHighlighterEx)highlighter).setTextAttributes(textAttributes);
    }

    @Override
    public void fireAttributesChanged(@NotNull RangeHighlighterEx segmentHighlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
        if (segmentHighlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(22);
        }
        for (MarkupModelListener listener2 : this.myListeners) {
            listener2.attributesChanged(segmentHighlighter, renderersChanged, fontStyleOrColorChanged);
        }
    }

    @Override
    public void fireAfterAdded(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(23);
        }
        for (MarkupModelListener listener2 : this.myListeners) {
            listener2.afterAdded(segmentHighlighter);
        }
    }

    @Override
    public void fireBeforeRemoved(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(24);
        }
        for (MarkupModelListener listener2 : this.myListeners) {
            listener2.beforeRemoved(segmentHighlighter);
        }
    }

    @Override
    public boolean containsHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Processor equalId = h -> h.getId() != ((RangeHighlighterEx)highlighter).getId();
        return !this.treeFor(highlighter).processOverlappingWith(highlighter.getStartOffset(), highlighter.getEndOffset(), equalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRangeHighlightersOverlappingWith(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            MarkupModelImpl.$$$reportNull$$$0(26);
        }
        MarkupIterator<RangeHighlighterEx> iterator2 = this.overlappingIterator(start2, end);
        try {
            while (iterator2.hasNext()) {
                if (processor2.process(iterator2.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            iterator2.dispose();
        }
    }

    @Override
    public boolean processRangeHighlightersOutside(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            MarkupModelImpl.$$$reportNull$$$0(27);
        }
        return this.myHighlighterTree.processOverlappingWithOutside(start2, end, processor2) && this.myHighlighterTreeForLines.processOverlappingWithOutside(start2, end, processor2);
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        startOffset = Math.max(0, startOffset);
        endOffset = Math.max(startOffset, endOffset);
        MarkupIterator<RangeHighlighterEx> markupIterator = IntervalTreeImpl.mergingOverlappingIterator(this.myHighlighterTree, new TextRangeInterval(startOffset, endOffset), this.myHighlighterTreeForLines, MarkupModelImpl.roundToLineBoundaries(this.getDocument(), startOffset, endOffset), RangeHighlighterEx.BY_AFFECTED_START_OFFSET);
        if (markupIterator == null) {
            MarkupModelImpl.$$$reportNull$$$0(28);
        }
        return markupIterator;
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset, boolean onlyRenderedInGutter) {
        startOffset = Math.max(0, startOffset);
        endOffset = Math.max(startOffset, endOffset);
        MarkupIterator<RangeHighlighterEx> exact = this.myHighlighterTree.overlappingIterator(new TextRangeInterval(startOffset, endOffset), onlyRenderedInGutter);
        MarkupIterator<RangeHighlighterEx> lines = this.myHighlighterTreeForLines.overlappingIterator(MarkupModelImpl.roundToLineBoundaries(this.getDocument(), startOffset, endOffset), onlyRenderedInGutter);
        MarkupIterator<RangeHighlighterEx> markupIterator = MarkupIterator.mergeIterators(exact, lines, RangeHighlighterEx.BY_AFFECTED_START_OFFSET);
        if (markupIterator == null) {
            MarkupModelImpl.$$$reportNull$$$0(29);
        }
        return markupIterator;
    }

    @NotNull
    public static TextRangeInterval roundToLineBoundaries(@NotNull Document document, int startOffset, int endOffset) {
        int lineStartOffset;
        if (document == null) {
            MarkupModelImpl.$$$reportNull$$$0(30);
        }
        int textLength = document.getTextLength();
        int n = startOffset <= 0 ? 0 : (lineStartOffset = startOffset > textLength ? textLength : document.getLineStartOffset(document.getLineNumber(startOffset)));
        int lineEndOffset = endOffset <= 0 ? 0 : (endOffset >= textLength ? textLength : document.getLineEndOffset(document.getLineNumber(endOffset)));
        return new TextRangeInterval(lineStartOffset, lineEndOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/MarkupModelImpl";
                break;
            }
            case 5: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetArea";
                break;
            }
            case 6: 
            case 8: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeAttributesAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 15: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentHighlighter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/MarkupModelImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addLineHighlighter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHighlighters";
                break;
            }
            case 7: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeHighlighter";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "overlappingIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 29: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlighterAndChangeAttributes";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlighter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changeAttributesInBatch";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlighter";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addMarkupModelListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeMarkupModelListener";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setRangeHighlighterAttributes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fireAttributesChanged";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterAdded";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeRemoved";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "containsHighlighter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlightersOverlappingWith";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlightersOutside";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "roundToLineBoundaries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

