/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorsSchemeImpl
extends AbstractColorsScheme
implements ExternalizableScheme {
    private final Map<String, TextAttributes> myAttributesTempMap = new ConcurrentHashMap<String, TextAttributes>();

    public EditorColorsSchemeImpl(EditorColorsScheme parentScheme) {
        super(parentScheme);
    }

    @Override
    public void copyTo(AbstractColorsScheme newScheme) {
        super.copyTo(newScheme);
        this.myAttributesTempMap.clear();
    }

    public void setAttributes(@NotNull TextAttributesKey key, @NotNull TextAttributes attributes) {
        if (key == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(1);
        }
        if (TextAttributesKey.isTemp((TextAttributesKey)key)) {
            this.myAttributesTempMap.put(key.getExternalName(), attributes);
        } else if (attributes == INHERITED_ATTRS_MARKER || !Comparing.equal((Object)attributes, (Object)this.getDirectlyDefinedAttributes(key))) {
            this.myAttributesMap.put(key.getExternalName(), attributes);
            this.myAttributesTempMap.clear();
        }
    }

    public void setColor(ColorKey key, Color color) {
        if (color == INHERITED_COLOR_MARKER || !EditorColorsSchemeImpl.colorsEqual(color, this.getDirectlyDefinedColor(key))) {
            this.myColorsMap.put(key, (Color)ObjectUtils.notNull((Object)color, (Object)NULL_COLOR_MARKER));
        }
    }

    public TextAttributes getAttributes(@Nullable TextAttributesKey key) {
        if (key != null) {
            if (TextAttributesKey.isTemp((TextAttributesKey)key)) {
                return this.myAttributesTempMap.get(key.getExternalName());
            }
            TextAttributes attributes = this.getDirectlyDefinedAttributes(key);
            if (attributes != null && attributes != INHERITED_ATTRS_MARKER) {
                return attributes;
            }
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            if (fallbackKey != null && (attributes = this.getFallbackAttributes(fallbackKey)) != null) {
                return attributes;
            }
        }
        return this.myParentScheme.getAttributes(key);
    }

    @Nullable
    public Color getColor(ColorKey key) {
        if (key != null) {
            Color color = this.getDirectlyDefinedColor(key);
            if (color == NULL_COLOR_MARKER) {
                return null;
            }
            if (color != null && color != INHERITED_COLOR_MARKER) {
                return color;
            }
            ColorKey fallbackKey = key.getFallbackColorKey();
            if (fallbackKey != null && (color = this.getFallbackColor(fallbackKey)) != null) {
                return color;
            }
        }
        return this.myParentScheme.getColor(key);
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this.myParentScheme);
        this.copyTo(newScheme);
        newScheme.setName(this.getName());
        newScheme.setDefaultMetaInfo(this);
        return newScheme;
    }

    @Override
    protected boolean attributesEqual(AbstractColorsScheme otherScheme) {
        return this.compareAttributes(otherScheme, new ArrayList<Predicate<? super TextAttributesKey>>());
    }

    @Override
    protected boolean colorsEqual(AbstractColorsScheme otherScheme, @Nullable Predicate<? super ColorKey> colorKeyFilter) {
        ArrayList<Predicate<? super ColorKey>> filters = new ArrayList<Predicate<? super ColorKey>>();
        if (colorKeyFilter != null) {
            filters.add(colorKeyFilter);
        }
        return this.compareColors(otherScheme, filters);
    }

    private boolean compareAttributes(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Predicate<? super TextAttributesKey>> filters) {
        if (otherScheme == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(2);
        }
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(3);
        }
        for (String keyName : this.myAttributesMap.keySet()) {
            TextAttributesKey key2 = TextAttributesKey.find((String)keyName);
            if (EditorColorsSchemeImpl.isTextAttributeKeyIgnored(filters, key2) || this.getAttributes(key2).equals((Object)otherScheme.getAttributes(key2))) continue;
            return false;
        }
        filters.add(key -> this.myAttributesMap.containsKey(key.getExternalName()));
        return !(this.myParentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.myParentScheme).compareAttributes(otherScheme, filters);
    }

    private static boolean isTextAttributeKeyIgnored(@NotNull Collection<? extends Predicate<? super TextAttributesKey>> filters, TextAttributesKey key) {
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(4);
        }
        for (Predicate<? super TextAttributesKey> predicate : filters) {
            if (!predicate.test((TextAttributesKey)key)) continue;
            return true;
        }
        return false;
    }

    private boolean compareColors(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Predicate<? super ColorKey>> filters) {
        if (otherScheme == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(5);
        }
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(6);
        }
        for (ColorKey key2 : this.myColorsMap.keySet()) {
            Color thisColor = this.getColor(key2);
            Color otherColor = otherScheme.getColor(key2);
            if (!EditorColorsSchemeImpl.isColorKeyAccepted(filters, key2) || Comparing.equal((Object)thisColor, (Object)otherColor)) continue;
            return false;
        }
        filters.add(key -> !this.myColorsMap.containsKey(key));
        return !(this.myParentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.myParentScheme).compareColors(otherScheme, filters);
    }

    private static boolean isColorKeyAccepted(@NotNull Collection<? extends Predicate<? super ColorKey>> filters, @NotNull ColorKey key) {
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(7);
        }
        if (key == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(8);
        }
        for (Predicate<? super ColorKey> predicate : filters) {
            if (predicate.test((ColorKey)key)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherScheme";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setAttributes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compareAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTextAttributeKeyIgnored";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "compareColors";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isColorKeyAccepted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

