/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.CopyPasteManagerEx;
import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.UIBundle;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiplePasteAction
extends AnAction
implements DumbAware {
    public MultiplePasteAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MultiplePasteAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Component focusedComponent = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (!(focusedComponent instanceof JComponent)) {
            return;
        }
        ClipboardContentChooser chooser = new ClipboardContentChooser(project);
        if (!chooser.getAllContents().isEmpty()) {
            chooser.show();
        } else {
            chooser.close(1);
        }
        if (chooser.getExitCode() == 0 || chooser.getExitCode() == MultiplePasteAction.getPasteSimpleExitCode()) {
            List selectedContents = chooser.getSelectedContents();
            CopyPasteManagerEx copyPasteManager = CopyPasteManagerEx.getInstanceEx();
            if (selectedContents.size() == 1) {
                copyPasteManager.moveContentToStackTop((Transferable)selectedContents.get(0));
            } else {
                copyPasteManager.setContents(new StringSelection(chooser.getSelectedText()));
            }
            if (editor != null) {
                if (editor.isViewer()) {
                    return;
                }
                AnAction pasteAction = ActionManager.getInstance().getAction(chooser.getExitCode() == MultiplePasteAction.getPasteSimpleExitCode() ? "EditorPasteSimple" : "$Paste");
                AnActionEvent newEvent = new AnActionEvent(e.getInputEvent(), DataManager.getInstance().getDataContext(focusedComponent), e.getPlace(), e.getPresentation(), ActionManager.getInstance(), e.getModifiers());
                pasteAction.actionPerformed(newEvent);
            } else {
                Action pasteAction = ((JComponent)focusedComponent).getActionMap().get("paste-from-clipboard");
                if (pasteAction != null) {
                    pasteAction.actionPerformed(new ActionEvent(focusedComponent, 1001, ""));
                }
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MultiplePasteAction.$$$reportNull$$$0(1);
        }
        boolean enabled = MultiplePasteAction.isEnabled(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setEnabled(enabled);
        }
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        Object component2;
        if (e == null) {
            MultiplePasteAction.$$$reportNull$$$0(2);
        }
        if (!((component2 = e.getData(PlatformDataKeys.CONTEXT_COMPONENT)) instanceof JComponent)) {
            return false;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            return !editor.isViewer();
        }
        Action pasteAction = ((JComponent)component2).getActionMap().get("paste-from-clipboard");
        return pasteAction != null;
    }

    private static int getPasteSimpleExitCode() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/editor/actions/MultiplePasteAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClipboardContentChooser
    extends ContentChooser<Transferable> {
        ClipboardContentChooser(Project project) {
            super(project, UIBundle.message((String)"choose.content.to.paste.dialog.title", (Object[])new Object[0]), true, true);
            this.setOKButtonText(ActionsBundle.actionText((String)"EditorPaste"));
            this.setOKButtonMnemonic(80);
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getHelpAction(), this.getOKAction(), new PasteSimpleAction(), this.getCancelAction()};
            if (actionArray == null) {
                ClipboardContentChooser.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        @Nullable
        protected String getHelpId() {
            return "ixPasteSelected";
        }

        @Override
        protected String getStringRepresentationFor(Transferable content2) {
            try {
                return (String)content2.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e1) {
                return "";
            }
        }

        @Override
        @NotNull
        protected List<Transferable> getContents() {
            List<Transferable> list2 = Arrays.asList(CopyPasteManager.getInstance().getAllContents());
            if (list2 == null) {
                ClipboardContentChooser.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        protected void removeContentAt(Transferable content2) {
            CopyPasteManagerEx.getInstanceEx().removeContent(content2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/editor/actions/MultiplePasteAction$ClipboardContentChooser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContents";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        final class PasteSimpleAction
        extends DialogWrapper.DialogWrapperAction {
            private PasteSimpleAction() {
                super((DialogWrapper)ClipboardContentChooser.this, ActionsBundle.actionText((String)"EditorPasteSimple"));
            }

            protected void doAction(ActionEvent e) {
                ClipboardContentChooser.this.close(MultiplePasteAction.getPasteSimpleExitCode());
            }
        }
    }
}

