/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ApplicationEx
extends Application {
    public static final String LOCATOR_FILE_NAME = ".home";
    public static final int FORCE_EXIT = 1;
    public static final int EXIT_CONFIRMED = 2;
    public static final int SAVE = 4;
    public static final int ELEVATE = 8;

    public void load();

    public boolean holdsReadLock();

    public boolean isWriteActionInProgress();

    public boolean isWriteActionPending();

    @ApiStatus.Internal
    default public void acquireWriteIntentLock(@NotNull String invokedClassFqn) {
        if (invokedClassFqn == null) {
            ApplicationEx.$$$reportNull$$$0(0);
        }
    }

    @ApiStatus.Internal
    default public void releaseWriteIntentLock() {
    }

    public boolean isSaveAllowed();

    public void setSaveAllowed(boolean var1);

    @Deprecated
    default public void doNotSave() {
        this.setSaveAllowed(false);
    }

    public boolean runProcessWithProgressSynchronouslyInReadAction(@Nullable Project var1, @NotNull @NlsContexts.ProgressTitle String var2, boolean var3, @NlsContexts.Button String var4, JComponent var5, @NotNull Runnable var6);

    default public void exit(int flags) {
        this.exit();
    }

    default public void exit() {
        this.exit(4);
    }

    default public void exit(boolean force, boolean exitConfirmed) {
        int flags = 4;
        if (force) {
            flags |= 1;
        }
        if (exitConfirmed) {
            flags |= 2;
        }
        this.exit(flags);
    }

    public void restart(boolean var1);

    default public void restart() {
        this.restart(false);
    }

    public void restart(boolean var1, boolean var2);

    @ApiStatus.Internal
    default public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull @NlsContexts.ProgressTitle String progressTitle2, boolean canBeCanceled, Project project) {
        if (process2 == null) {
            ApplicationEx.$$$reportNull$$$0(1);
        }
        if (progressTitle2 == null) {
            ApplicationEx.$$$reportNull$$$0(2);
        }
        return this.runProcessWithProgressSynchronously(process2, progressTitle2, canBeCanceled, true, project, null, null);
    }

    @ApiStatus.Internal
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @NlsContexts.ProgressTitle String var2, boolean var3, boolean var4, @Nullable Project var5, JComponent var6, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String var7);

    public void assertIsDispatchThread(@Nullable JComponent var1);

    public void assertTimeConsuming();

    public boolean tryRunReadAction(@NotNull Runnable var1);

    @ApiStatus.Internal
    default public void executeByImpatientReader(@NotNull Runnable runnable2) throws ApplicationUtil.CannotRunReadActionException {
        if (runnable2 == null) {
            ApplicationEx.$$$reportNull$$$0(3);
        }
        runnable2.run();
    }

    @ApiStatus.Experimental
    default public boolean runWriteActionWithCancellableProgressInDispatchThread(@NotNull String title, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title == null) {
            ApplicationEx.$$$reportNull$$$0(4);
        }
        if (action2 == null) {
            ApplicationEx.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Experimental
    default public boolean runWriteActionWithNonCancellableProgressInDispatchThread(@NotNull String title, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title == null) {
            ApplicationEx.$$$reportNull$$$0(6);
        }
        if (action2 == null) {
            ApplicationEx.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    default public boolean isInImpatientReader() {
        return false;
    }

    @ApiStatus.Internal
    default public <T, E extends Throwable> T runUnlockingIntendedWrite(@NotNull ThrowableComputable<T, E> action2) throws E {
        if (action2 == null) {
            ApplicationEx.$$$reportNull$$$0(8);
        }
        return (T)action2.compute();
    }

    @ApiStatus.Internal
    default public void runIntendedWriteActionOnCurrentThread(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationEx.$$$reportNull$$$0(9);
        }
        action2.run();
    }

    @ApiStatus.Internal
    default public boolean isExitInProgress() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokedClassFqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/ex/ApplicationEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "acquireWriteIntentLock";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeByImpatientReader";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runWriteActionWithCancellableProgressInDispatchThread";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runWriteActionWithNonCancellableProgressInDispatchThread";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "runUnlockingIntendedWrite";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "runIntendedWriteActionOnCurrentThread";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

