/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.util.NlsContexts;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MarkerOptionalData
extends BitSet {
    private final Int2ObjectMap<Throwable> myDebugAllocationPositions = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<@Nls String> myDoneErrors = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<WhitespacesAndCommentsBinder> myLeftBinders = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<WhitespacesAndCommentsBinder> myRightBinders = new Int2ObjectOpenHashMap();
    private final IntSet myCollapsed = new IntOpenHashSet();

    MarkerOptionalData() {
    }

    void clean(int markerId) {
        if (this.get(markerId)) {
            this.set(markerId, false);
            this.myLeftBinders.remove(markerId);
            this.myRightBinders.remove(markerId);
            this.myDoneErrors.remove(markerId);
            this.myCollapsed.remove(markerId);
            this.myDebugAllocationPositions.remove(markerId);
        }
    }

    @Nullable
    @NlsContexts.DetailedDescription
    String getDoneError(int markerId) {
        return (String)this.myDoneErrors.get(markerId);
    }

    boolean isCollapsed(int markerId) {
        return this.myCollapsed.contains(markerId);
    }

    void setErrorMessage(int markerId, @NotNull @Nls String message) {
        if (message == null) {
            MarkerOptionalData.$$$reportNull$$$0(0);
        }
        this.markAsHavingOptionalData(markerId);
        this.myDoneErrors.put(markerId, (Object)message);
    }

    void markCollapsed(int markerId) {
        this.markAsHavingOptionalData(markerId);
        this.myCollapsed.add(markerId);
    }

    private void markAsHavingOptionalData(int markerId) {
        this.set(markerId);
    }

    void notifyAllocated(int markerId) {
        this.markAsHavingOptionalData(markerId);
        this.myDebugAllocationPositions.put(markerId, (Object)new Throwable("Created at the following trace."));
    }

    Throwable getAllocationTrace(PsiBuilderImpl.StartMarker marker) {
        return (Throwable)this.myDebugAllocationPositions.get(marker.markerId);
    }

    WhitespacesAndCommentsBinder getBinder(int markerId, boolean right) {
        WhitespacesAndCommentsBinder binder = this.get(markerId) ? (WhitespacesAndCommentsBinder)this.getBinderMap(right).get(markerId) : null;
        return binder != null ? binder : MarkerOptionalData.getDefaultBinder(right);
    }

    void assignBinder(int markerId, @NotNull WhitespacesAndCommentsBinder binder, boolean right) {
        if (binder == null) {
            MarkerOptionalData.$$$reportNull$$$0(1);
        }
        Int2ObjectMap<WhitespacesAndCommentsBinder> map2 = this.getBinderMap(right);
        if (binder != MarkerOptionalData.getDefaultBinder(right)) {
            this.markAsHavingOptionalData(markerId);
            map2.put(markerId, (Object)binder);
        } else {
            map2.remove(markerId);
        }
    }

    private static WhitespacesAndCommentsBinder getDefaultBinder(boolean right) {
        return right ? WhitespacesBinders.DEFAULT_RIGHT_BINDER : WhitespacesBinders.DEFAULT_LEFT_BINDER;
    }

    private Int2ObjectMap<WhitespacesAndCommentsBinder> getBinderMap(boolean right) {
        return right ? this.myRightBinders : this.myLeftBinders;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/impl/MarkerOptionalData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setErrorMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "assignBinder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

