/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.project;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/project/ProjectFsStatsCollector;", "", "()V", "groupId", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "caseSensitivity", "", "project", "Lcom/intellij/openapi/project/Project;", "value", "", "watchedRoots", "pctNonWatched", "", "intellij.platform.ide.impl"})
public final class ProjectFsStatsCollector {
    private static final EventLogGroup groupId;
    public static final ProjectFsStatsCollector INSTANCE;

    @JvmStatic
    public static final void caseSensitivity(@NotNull Project project, boolean value2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FUStateUsagesLogger.logStateEvent((EventLogGroup)groupId, (String)"case-sensitivity", (FeatureUsageData)new FeatureUsageData().addProject(project).addData("cs-project", value2).addData("cs-system", SystemInfo.isFileSystemCaseSensitive).addData("cs-implicit", System.getProperty("idea.case.sensitive.fs") == null));
    }

    @JvmStatic
    public static final void watchedRoots(@NotNull Project project, int pctNonWatched) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FUStateUsagesLogger.logStateEvent((EventLogGroup)groupId, (String)"roots-watched", (FeatureUsageData)new FeatureUsageData().addProject(project).addData("pct-non-watched", pctNonWatched));
    }

    private ProjectFsStatsCollector() {
    }

    static {
        ProjectFsStatsCollector projectFsStatsCollector;
        INSTANCE = projectFsStatsCollector = new ProjectFsStatsCollector();
        groupId = new EventLogGroup("project.fs", 1);
    }
}

