/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.internal.InternalActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class LoadAllContentsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(LoadAllContentsAction.class);
    private final AtomicInteger count = new AtomicInteger();
    private final AtomicLong totalSize = new AtomicLong();

    LoadAllContentsAction() {
        super(InternalActionsBundle.messagePointer("action.AnAction.text.load.all.files.content", new Object[0]), InternalActionsBundle.messagePointer("action.AnAction.description.load.all.files.content", new Object[0]), null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadAllContentsAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        String m = "Started loading content";
        LOG.info(m);
        System.out.println(m);
        long start2 = System.currentTimeMillis();
        this.count.set(0);
        this.totalSize.set(0L);
        ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronously(() -> ProjectRootManager.getInstance((Project)project).getFileIndex().iterateContent(fileOrDir -> {
            if (fileOrDir.isDirectory() || fileOrDir.is(VFileProperty.SPECIAL)) {
                return true;
            }
            try {
                this.count.incrementAndGet();
                byte[] bytes = FileUtil.loadFileBytes((File)new File(fileOrDir.getPath()));
                this.totalSize.addAndGet(bytes.length);
                ProgressManager.getInstance().getProgressIndicator().setText(fileOrDir.getPresentableUrl());
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
            return true;
        }), "Loading", false, project);
        long end = System.currentTimeMillis();
        String message = "Finished loading content of " + this.count + " files. Total size=" + StringUtil.formatFileSize((long)this.totalSize.get()) + ". Elapsed=" + (end - start2) / 1000L + "sec.";
        LOG.info(message);
        System.out.println(message);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            LoadAllContentsAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PROJECT) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/internal/LoadAllContentsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

