/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Changeable;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class RegistryBooleanOptionDescriptor
extends BooleanOptionDescription
implements Changeable {
    protected final String myKey;

    public RegistryBooleanOptionDescriptor(@NlsContexts.Label String option2, String registryKey) {
        super(option2, null);
        this.myKey = registryKey;
    }

    public boolean isOptionEnabled() {
        return Registry.is((String)this.myKey);
    }

    public void setOptionState(boolean enabled) {
        Registry.get((String)this.myKey).setValue(enabled);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            RegistryBooleanOptionDescriptor.suggestRestartIfNecessary(null);
        }
    }

    public boolean hasChanged() {
        return Registry.get((String)this.myKey).isChangedFromDefault();
    }

    public static void suggestRestartIfNecessary(@Nullable JComponent parentComponent) {
        if (Registry.getInstance().isRestartNeeded()) {
            RegistryBooleanOptionDescriptor.suggestRestart(parentComponent);
        }
    }

    public static void suggestRestart(@Nullable JComponent parentComponent) {
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        String title = IdeBundle.message((String)"dialog.title.restart.required", (Object[])new Object[0]);
        String message = IdeBundle.message((String)"dialog.message.must.be.restarted.for.changes.to.take.effect", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        String okText = IdeBundle.message((String)"button.now", (Object[])new Object[]{app.isRestartCapable() ? 0 : 1});
        String cancelText = IdeBundle.message((String)"button.later", (Object[])new Object[]{app.isRestartCapable() ? 0 : 1});
        int result2 = parentComponent != null ? Messages.showOkCancelDialog((Component)parentComponent, (String)message, (String)title, (String)okText, (String)cancelText, (Icon)Messages.getQuestionIcon()) : Messages.showOkCancelDialog((String)message, (String)title, (String)okText, (String)cancelText, (Icon)Messages.getQuestionIcon());
        if (result2 == 0) {
            ApplicationManager.getApplication().invokeLater(() -> app.restart(true), ModalityState.NON_MODAL);
        }
    }
}

