/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom;

import com.intellij.ide.highlighter.custom.tokens.TokenInfo;
import com.intellij.ide.highlighter.custom.tokens.TokenParser;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AbstractCustomLexer
extends LexerBase {
    protected CharSequence myBuffer = Strings.EMPTY_CHAR_SEQUENCE;
    protected int myStartOffset = 0;
    protected int myEndOffset = 0;
    private final TokenParser[] myTokenParsers;
    protected TokenInfo myCurrentToken;
    protected int myPosition;

    public AbstractCustomLexer(List<TokenParser> tokenParsers) {
        this.myTokenParsers = tokenParsers.toArray(new TokenParser[0]);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            AbstractCustomLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myPosition = this.myStartOffset;
        this.myCurrentToken = new TokenInfo();
        for (TokenParser tokenParser : this.myTokenParsers) {
            tokenParser.setBuffer(this.myBuffer, this.myStartOffset, this.myEndOffset);
        }
        this.advance();
    }

    public int getState() {
        return 0;
    }

    public IElementType getTokenType() {
        return this.myCurrentToken.getType();
    }

    public int getTokenStart() {
        return this.myCurrentToken.getStart();
    }

    public int getTokenEnd() {
        return this.myCurrentToken.getEnd();
    }

    public void advance() {
        if (this.myPosition >= this.myEndOffset) {
            this.myCurrentToken.updateData(this.myPosition, this.myPosition, null);
            return;
        }
        boolean tokenFound = false;
        for (TokenParser tokenParser : this.myTokenParsers) {
            if (!tokenParser.hasToken(this.myPosition)) continue;
            tokenParser.getTokenInfo(this.myCurrentToken);
            if (this.myCurrentToken.getEnd() <= this.myCurrentToken.getStart()) {
                throw new AssertionError(tokenParser);
            }
            tokenFound = true;
            break;
        }
        if (!tokenFound) {
            this.handleTokenNotFound();
        }
        this.myPosition = this.myCurrentToken.getEnd();
    }

    protected void handleTokenNotFound() {
        this.myCurrentToken.updateData(this.myPosition, this.myPosition + 1, CustomHighlighterTokenType.CHARACTER);
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            AbstractCustomLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/highlighter/custom/AbstractCustomLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/highlighter/custom/AbstractCustomLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

