/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.actions;

import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromTemplateActionBase
extends AnAction {
    public CreateFromTemplateActionBase(@NlsActions.ActionText String title, @NlsActions.ActionDescription String description, Icon icon2) {
        super(title, description, icon2);
    }

    public CreateFromTemplateActionBase(@NotNull Supplier<String> dynamicTitle, @NotNull Supplier<String> dynamicDescription, Icon icon2) {
        if (dynamicTitle == null) {
            CreateFromTemplateActionBase.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            CreateFromTemplateActionBase.$$$reportNull$$$0(1);
        }
        super(dynamicTitle, dynamicDescription, icon2);
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        IdeView view;
        if (e == null) {
            CreateFromTemplateActionBase.$$$reportNull$$$0(2);
        }
        if ((view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext = e.getDataContext())) == null) {
            return;
        }
        PsiDirectory dir = this.getTargetDirectory(dataContext, view);
        if (dir == null) {
            return;
        }
        Project project = dir.getProject();
        FileTemplate selectedTemplate = this.getTemplate(project, dir);
        if (selectedTemplate != null) {
            AnAction action2 = this.getReplacedAction(selectedTemplate);
            if (action2 != null) {
                action2.actionPerformed(e);
            } else {
                FileTemplateManager.getInstance(project).addRecentName(selectedTemplate.getName());
                AttributesDefaults defaults = this.getAttributesDefaults(dataContext);
                Properties properties = defaults != null ? defaults.getDefaultProperties() : null;
                CreateFromTemplateDialog dialog2 = new CreateFromTemplateDialog(project, dir, selectedTemplate, defaults, properties);
                PsiElement createdElement = dialog2.create();
                if (createdElement != null) {
                    this.elementCreated(dialog2, createdElement);
                    view.selectElement(createdElement);
                    if (selectedTemplate.isLiveTemplateEnabled() && createdElement instanceof PsiFile) {
                        Map<String, String> defaultValues = this.getLiveTemplateDefaults(dataContext, (PsiFile)createdElement);
                        CreateFromTemplateActionBase.startLiveTemplate((PsiFile)createdElement, (Map)ObjectUtils.notNull(defaultValues, Collections.emptyMap()));
                    }
                }
            }
        }
    }

    public static void startLiveTemplate(@NotNull PsiFile file2) {
        if (file2 == null) {
            CreateFromTemplateActionBase.$$$reportNull$$$0(3);
        }
        CreateFromTemplateActionBase.startLiveTemplate(file2, Collections.emptyMap());
    }

    public static void startLiveTemplate(@NotNull PsiFile file2, @NotNull Map<String, String> defaultValues) {
        Editor editor;
        if (file2 == null) {
            CreateFromTemplateActionBase.$$$reportNull$$$0(4);
        }
        if (defaultValues == null) {
            CreateFromTemplateActionBase.$$$reportNull$$$0(5);
        }
        if ((editor = EditorHelper.openInEditor((PsiElement)file2)) == null) {
            return;
        }
        TemplateImpl template = new TemplateImpl("", file2.getText(), "");
        template.setInline(true);
        int count = template.getSegmentsCount();
        if (count == 0) {
            return;
        }
        HashSet<String> variables = new HashSet<String>();
        for (int i2 = 0; i2 < count; ++i2) {
            variables.add(template.getSegmentName(i2));
        }
        variables.removeAll(TemplateImpl.INTERNAL_VARS_SET);
        for (String variable : variables) {
            String defaultValue = defaultValues.getOrDefault(variable, variable);
            template.addVariable(variable, null, "\"" + defaultValue + "\"", true);
        }
        Project project = file2.getProject();
        WriteCommandAction.runWriteCommandAction((Project)project, () -> editor.getDocument().setText((CharSequence)template.getTemplateText()));
        editor.getCaretModel().moveToOffset(0);
        TemplateManager.getInstance(project).startTemplate(editor, template);
    }

    @Nullable
    protected PsiDirectory getTargetDirectory(DataContext dataContext, IdeView view) {
        return DirectoryChooserUtil.getOrChooseDirectory(view);
    }

    protected abstract FileTemplate getTemplate(Project var1, PsiDirectory var2);

    @Nullable
    protected AnAction getReplacedAction(FileTemplate selectedTemplate) {
        return null;
    }

    @Nullable
    protected AttributesDefaults getAttributesDefaults(DataContext dataContext) {
        return null;
    }

    protected void elementCreated(CreateFromTemplateDialog dialog2, PsiElement createdElement) {
    }

    @Nullable
    protected Map<String, String> getLiveTemplateDefaults(DataContext dataContext, @NotNull PsiFile file2) {
        if (file2 == null) {
            CreateFromTemplateActionBase.$$$reportNull$$$0(6);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicTitle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValues";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/fileTemplates/actions/CreateFromTemplateActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startLiveTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getLiveTemplateDefaults";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

