/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.Advertiser;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BigPopupUI
extends BorderLayoutPanel
implements Disposable {
    private static final int MINIMAL_SUGGESTIONS_LIST_HEIGHT = 100;
    @Nullable
    protected final Project myProject;
    protected ExtendableTextField mySearchField;
    protected JPanel suggestionsPanel;
    protected JBList<Object> myResultsList;
    protected JBPopup myHint;
    protected Runnable searchFinishedHandler = () -> {};
    protected final List<ViewTypeListener> myViewTypeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    protected ViewType myViewType = ViewType.SHORT;
    protected Advertiser myHintLabel;

    public BigPopupUI(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public abstract JBList<Object> createList();

    @NotNull
    protected abstract ListCellRenderer<Object> createCellRenderer();

    @NotNull
    protected abstract JPanel createTopLeftPanel();

    @NotNull
    protected abstract JPanel createSettingsPanel();

    @NotNull
    @NlsContexts.PopupAdvertisement
    protected String[] getInitialHints() {
        String[] stringArray;
        String hint = this.getInitialHint();
        if (hint != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = hint;
        } else {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (stringArray == null) {
            BigPopupUI.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @Nullable
    @NlsContexts.PopupAdvertisement
    protected String getInitialHint() {
        return null;
    }

    @NotNull
    protected abstract String getAccessibleName();

    protected void installScrollingActions() {
        ScrollingUtil.installActions(this.myResultsList, (JComponent)this.getSearchField());
    }

    @NotNull
    protected ExtendableTextField createSearchField() {
        return new SearchField();
    }

    public void init() {
        this.withBackground(JBUI.CurrentTheme.BigPopup.headerBackground());
        this.myResultsList = this.createList();
        JPanel topLeftPanel = this.createTopLeftPanel();
        JPanel settingsPanel = this.createSettingsPanel();
        this.mySearchField = this.createSearchField();
        this.suggestionsPanel = this.createSuggestionsPanel();
        this.myResultsList.setFocusable(false);
        this.myResultsList.setCellRenderer(this.createCellRenderer());
        if (Registry.is((String)"new.search.everywhere.use.editor.font")) {
            Font editorFont = EditorUtil.getEditorFont();
            this.myResultsList.setFont(editorFont);
        }
        this.installScrollingActions();
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setOpaque(false);
        topPanel.add((Component)topLeftPanel, "West");
        topPanel.add((Component)settingsPanel, "East");
        topPanel.add((Component)this.mySearchField, "South");
        WindowMoveListener moveListener = new WindowMoveListener((Component)((Object)this));
        topPanel.addMouseListener(moveListener);
        topPanel.addMouseMotionListener(moveListener);
        this.addToTop(topPanel);
        this.addToCenter(this.suggestionsPanel);
        this.getAccessibleContext().setAccessibleName(this.getAccessibleName());
    }

    protected void addListDataListener(@NotNull AbstractListModel<Object> model2) {
        if (model2 == null) {
            BigPopupUI.$$$reportNull$$$0(1);
        }
        model2.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                BigPopupUI.this.updateViewType(ViewType.FULL);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                if (BigPopupUI.this.myResultsList.isEmpty() && BigPopupUI.this.getSearchPattern().isEmpty()) {
                    BigPopupUI.this.updateViewType(ViewType.SHORT);
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                BigPopupUI.this.updateViewType(BigPopupUI.this.myResultsList.isEmpty() && BigPopupUI.this.getSearchPattern().isEmpty() ? ViewType.SHORT : ViewType.FULL);
            }
        });
    }

    @NotNull
    protected String getSearchPattern() {
        String string = Optional.ofNullable(this.mySearchField).map(JTextComponent::getText).orElse("");
        if (string == null) {
            BigPopupUI.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void updateViewType(@NotNull ViewType viewType) {
        if (viewType == null) {
            BigPopupUI.$$$reportNull$$$0(3);
        }
        if (this.myViewType != viewType) {
            this.myViewType = viewType;
            this.myViewTypeListeners.forEach(listener2 -> listener2.suggestionsShown(viewType));
        }
    }

    private JPanel createSuggestionsPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.setOpaque(false);
        pnl.setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.BigPopup.searchFieldBorderColor(), (int)1, (int)0, (int)0, (int)0));
        JBScrollPane resultsScroll = new JBScrollPane(this.myResultsList);
        resultsScroll.setBorder(null);
        resultsScroll.setHorizontalScrollBarPolicy(31);
        ComponentUtil.putClientProperty((JComponent)resultsScroll.getVerticalScrollBar(), (Key)JBScrollPane.IGNORE_SCROLLBAR_IN_INSETS, (Object)true);
        resultsScroll.setPreferredSize((Dimension)JBUI.size((int)670, (int)JBUI.CurrentTheme.BigPopup.maxListHeight()));
        pnl.add((Component)resultsScroll, "Center");
        this.myHintLabel = this.createHint();
        pnl.add((Component)this.myHintLabel.getAdComponent(), "South");
        return pnl;
    }

    @NotNull
    private Advertiser createHint() {
        Advertiser advertiser = new Advertiser();
        advertiser.setBorder(JBUI.CurrentTheme.BigPopup.advertiserBorder());
        advertiser.setBackground(JBUI.CurrentTheme.BigPopup.advertiserBackground());
        advertiser.setForeground(JBUI.CurrentTheme.BigPopup.advertiserForeground());
        for (String s : this.getInitialHints()) {
            advertiser.addAdvertisement(s, null);
        }
        advertiser.showRandomText();
        JComponent hintLabel = advertiser.getAdComponent();
        Dimension size = hintLabel.getPreferredSize();
        size.height = JBUIScale.scale((int)17);
        hintLabel.setPreferredSize(size);
        Advertiser advertiser2 = advertiser;
        if (advertiser2 == null) {
            BigPopupUI.$$$reportNull$$$0(4);
        }
        return advertiser2;
    }

    @NotNull
    public JTextField getSearchField() {
        ExtendableTextField extendableTextField = this.mySearchField;
        if (extendableTextField == null) {
            BigPopupUI.$$$reportNull$$$0(5);
        }
        return extendableTextField;
    }

    public Dimension getMinimumSize() {
        Dimension size = this.calcPrefSize(ViewType.SHORT);
        if (this.getViewType() == ViewType.FULL) {
            size.height += 100;
        }
        return size;
    }

    public Dimension getPreferredSize() {
        return this.calcPrefSize(this.myViewType);
    }

    public Dimension getExpandedSize() {
        return this.calcPrefSize(ViewType.FULL);
    }

    private Dimension calcPrefSize(ViewType viewType) {
        Dimension size = super.getPreferredSize();
        if (viewType == ViewType.SHORT) {
            size.height -= this.suggestionsPanel.getPreferredSize().height;
        }
        return size;
    }

    public void setSearchFinishedHandler(@NotNull Runnable searchFinishedHandler) {
        if (searchFinishedHandler == null) {
            BigPopupUI.$$$reportNull$$$0(6);
        }
        this.searchFinishedHandler = searchFinishedHandler;
    }

    public ViewType getViewType() {
        return this.myViewType;
    }

    public void addViewTypeListener(ViewTypeListener listener2) {
        this.myViewTypeListeners.add(listener2);
    }

    public void removeViewTypeListener(ViewTypeListener listener2) {
        this.myViewTypeListeners.remove(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/BigPopupUI";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFinishedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialHints";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/BigPopupUI";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchPattern";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createHint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchField";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addListDataListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateViewType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSearchFinishedHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ViewTypeListener {
        public void suggestionsShown(@NotNull ViewType var1);
    }

    public static enum ViewType {
        FULL,
        SHORT;

    }

    protected static class SearchField
    extends ExtendableTextField {
        public SearchField() {
            int fontDelta;
            ExtendableTextComponent.Extension leftExtension = this.getLeftExtension();
            ExtendableTextComponent.Extension rightExtension = this.getRightExtension();
            if (leftExtension != null) {
                this.addExtension(leftExtension);
            }
            if (rightExtension != null) {
                this.addExtension(rightExtension);
            }
            Insets insets = JBUI.CurrentTheme.BigPopup.searchFieldInsets();
            JBEmptyBorder empty = JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right);
            Border topLine = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.BigPopup.searchFieldBorderColor(), (int)1, (int)0, (int)0, (int)0);
            this.setBorder(JBUI.Borders.merge((Border)empty, (Border)topLine, (boolean)true));
            this.setBackground(JBUI.CurrentTheme.BigPopup.searchFieldBackground());
            this.setFocusTraversalKeysEnabled(false);
            if (Registry.is((String)"new.search.everywhere.use.editor.font")) {
                Font editorFont = EditorUtil.getEditorFont();
                this.setFont(editorFont);
            }
            if ((fontDelta = Registry.intValue((String)"new.search.everywhere.font.size.delta")) != 0) {
                Font font = this.getFont();
                font = font.deriveFont((float)fontDelta + (float)font.getSize());
                this.setFont(font);
            }
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = Integer.max(JBUIScale.scale((int)29), size.height);
            return size;
        }

        @Nullable
        protected ExtendableTextComponent.Extension getRightExtension() {
            return null;
        }

        @Nullable
        protected ExtendableTextComponent.Extension getLeftExtension() {
            return null;
        }
    }
}

