/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ui.hover.HoverListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HoverService {
    private final ComponentPoint outer = new ComponentPoint();
    private final ComponentPoint inner = new ComponentPoint();

    HoverService() {
    }

    void process(@NotNull AWTEvent event) {
        if (event == null) {
            HoverService.$$$reportNull$$$0(0);
        }
        if (event instanceof MouseEvent) {
            this.process((MouseEvent)event);
        }
    }

    private void process(@NotNull MouseEvent event) {
        if (event == null) {
            HoverService.$$$reportNull$$$0(1);
        }
        Component component2 = HoverService.getShowingComponent(event);
        this.outer.updateComponent(component2);
        this.outer.x = event.getXOnScreen();
        this.outer.y = event.getYOnScreen();
        this.updateHovered(component2 == null ? null : HoverService.getHoveredComponent(component2, event.getX(), event.getY()));
    }

    private void updateHovered(@Nullable Component component2) {
        Component old = this.inner.updateComponent(component2);
        if (component2 != old && old != null) {
            HoverListener.getAll((Component)old).forEach(listener2 -> listener2.mouseExited(old));
        }
        if (component2 != null) {
            Point point = new Point(this.outer.x, this.outer.y);
            SwingUtilities.convertPointFromScreen(point, component2);
            if (component2 != old) {
                this.inner.x = point.x;
                this.inner.y = point.y;
                HoverListener.getAll((Component)component2).forEach(listener2 -> listener2.mouseEntered(component2, point.x, point.y));
            } else if (this.inner.x != point.x || this.inner.y != point.y) {
                this.inner.x = point.x;
                this.inner.y = point.y;
                HoverListener.getAll((Component)component2).forEach(listener2 -> listener2.mouseMoved(component2, point.x, point.y));
            }
        }
    }

    @Nullable
    private static Component getShowingComponent(@NotNull MouseEvent event) {
        if (event == null) {
            HoverService.$$$reportNull$$$0(2);
        }
        if (505 == event.getID()) {
            return null;
        }
        Component component2 = event.getComponent();
        return component2 != null && component2.isShowing() ? component2 : null;
    }

    @Nullable
    private static Component getHoveredComponent(@NotNull Component parent, @Nullable Component child2, int x, int y) {
        if (parent == null) {
            HoverService.$$$reportNull$$$0(3);
        }
        return parent != child2 && child2 != null && child2.isVisible() ? HoverService.getHoveredComponent(child2, x - child2.getX(), y - child2.getY()) : null;
    }

    @Nullable
    private static Component getHoveredComponent(@NotNull Component parent, int x, int y) {
        if (parent == null) {
            HoverService.$$$reportNull$$$0(4);
        }
        if (parent instanceof Container) {
            if (!parent.contains(x, y)) {
                return null;
            }
            Container container = (Container)parent;
            for (Component child2 : container.getComponents()) {
                Component component2 = HoverService.getHoveredComponent(parent, child2, x, y);
                if (component2 == null) continue;
                return component2;
            }
        } else {
            Component component3 = HoverService.getHoveredComponent(parent, parent.getComponentAt(x, y), x, y);
            if (component3 != null) {
                return component3;
            }
        }
        return HoverListener.getAll((Component)parent).isEmpty() ? null : parent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/HoverService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getShowingComponent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getHoveredComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ComponentPoint {
        private WeakReference<Component> reference;
        int x;
        int y;

        private ComponentPoint() {
        }

        @Nullable
        Component getComponent() {
            WeakReference<Component> reference2 = this.reference;
            return reference2 == null ? null : (Component)reference2.get();
        }

        @Nullable
        Component updateComponent(@Nullable Component component2) {
            Component old = this.getComponent();
            if (component2 == null) {
                this.reference = null;
            } else if (component2 != old) {
                this.reference = new WeakReference<Component>(component2);
            }
            return old;
        }
    }
}

