/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.templateLanguages.BlockUtil;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import gnu.trove.THashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataLanguageBlockWrapper
implements ASTBlock,
BlockEx,
BlockWithParent {
    private final Block myOriginal;
    @Nullable
    private final Language myLanguage;
    private List<Block> myBlocks;
    private List<TemplateLanguageBlock> myTlBlocks;
    private BlockWithParent myParent;
    private DataLanguageBlockWrapper myRightHandWrapper;
    private Spacing mySpacing;
    private Map<Pair<Block, Block>, Spacing> myChildDataBorderSpacings;

    private DataLanguageBlockWrapper(@NotNull Block original) {
        PsiElement psi;
        if (original == null) {
            DataLanguageBlockWrapper.$$$reportNull$$$0(0);
        }
        assert (!(original instanceof DataLanguageBlockWrapper) && !(original instanceof TemplateLanguageBlock));
        this.myOriginal = original;
        ASTNode node = this.getNode();
        Language language = null;
        if (node != null && (psi = node.getPsi()) != null) {
            language = psi.getContainingFile().getLanguage();
        }
        this.myLanguage = language;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myOriginal.getTextRange();
        if (textRange == null) {
            DataLanguageBlockWrapper.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.myBlocks == null) {
            this.myBlocks = this.buildBlocks();
            this.initSpacings();
        }
        List<Block> list2 = this.myBlocks;
        if (list2 == null) {
            DataLanguageBlockWrapper.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private void initSpacings() {
        for (int i2 = 0; i2 < this.myBlocks.size(); ++i2) {
            Block block2;
            Block block1 = i2 == 0 ? null : this.myBlocks.get(i2 - 1);
            Spacing spacing = this.calcChildSpacing(i2, block1, block2 = this.myBlocks.get(i2));
            if (spacing == null) continue;
            this.registerChildSpacing(block1, block2, spacing);
        }
    }

    @Nullable
    private Spacing calcChildSpacing(int index2, @Nullable Block block1, @NotNull Block block2) {
        Spacing spacing;
        if (block2 == null) {
            DataLanguageBlockWrapper.$$$reportNull$$$0(3);
        }
        if (block1 instanceof TemplateLanguageBlock && (spacing = ((TemplateLanguageBlock)block1).getRightNeighborSpacing(block2, this, index2 - 1)) != null) {
            return spacing;
        }
        if (block2 instanceof TemplateLanguageBlock) {
            return ((TemplateLanguageBlock)block2).getLeftNeighborSpacing(block1, this, index2);
        }
        return null;
    }

    private void registerChildSpacing(@Nullable Block block1, @NotNull Block block2, Spacing spacing) {
        if (block2 == null) {
            DataLanguageBlockWrapper.$$$reportNull$$$0(4);
        }
        if (this.myChildDataBorderSpacings == null) {
            this.myChildDataBorderSpacings = new THashMap();
        }
        this.myChildDataBorderSpacings.put((Pair<Block, Block>)Pair.create((Object)block1, (Object)block2), spacing);
    }

    @Nullable
    public Language getLanguage() {
        return this.myLanguage;
    }

    private List<Block> buildBlocks() {
        assert (this.myBlocks == null);
        if (this.isLeaf()) {
            return AbstractBlock.EMPTY;
        }
        List<DataLanguageBlockWrapper> subWrappers = BlockUtil.buildChildWrappers(this.myOriginal);
        List<DataLanguageBlockWrapper> children2 = this.myTlBlocks == null ? new ArrayList<DataLanguageBlockWrapper>(subWrappers) : (subWrappers.size() == 0 ? BlockUtil.splitBlockIntoFragments(this.myOriginal, this.myTlBlocks) : BlockUtil.mergeBlocks(this.myTlBlocks, subWrappers));
        return BlockUtil.setParent(children2, this);
    }

    public Wrap getWrap() {
        BlockWithParent parent = this.getParent();
        if (parent instanceof TemplateLanguageBlock) {
            return ((TemplateLanguageBlock)parent).substituteTemplateChildWrap(this, this.myOriginal.getWrap());
        }
        return this.myOriginal.getWrap();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = this.myOriginal.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            DataLanguageBlockWrapper.$$$reportNull$$$0(5);
        }
        return childAttributes;
    }

    public Indent getIndent() {
        return this.myOriginal.getIndent();
    }

    public Alignment getAlignment() {
        return this.myOriginal.getAlignment();
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            DataLanguageBlockWrapper.$$$reportNull$$$0(6);
        }
        if (child1 instanceof DataLanguageBlockWrapper && child2 instanceof DataLanguageBlockWrapper) {
            return this.myOriginal.getSpacing(((DataLanguageBlockWrapper)child1).myOriginal, ((DataLanguageBlockWrapper)child2).myOriginal);
        }
        if ((child1 instanceof TemplateLanguageBlock || child2 instanceof TemplateLanguageBlock) && this.myChildDataBorderSpacings != null) {
            return this.myChildDataBorderSpacings.get(Pair.create((Object)child1, (Object)child2));
        }
        return null;
    }

    public boolean isIncomplete() {
        return this.myOriginal.isIncomplete();
    }

    public boolean isLeaf() {
        return this.myTlBlocks == null && this.myOriginal.isLeaf();
    }

    void addTlChild(TemplateLanguageBlock tlBlock) {
        assert (this.myBlocks == null);
        if (this.myTlBlocks == null) {
            this.myTlBlocks = new ArrayList<TemplateLanguageBlock>(5);
        }
        this.myTlBlocks.add(tlBlock);
        tlBlock.setParent(this);
    }

    public Block getOriginal() {
        return this.myOriginal;
    }

    public String toString() {
        String tlBlocksInfo = " TlBlocks " + (Serializable)(this.myTlBlocks == null ? "0" : Integer.valueOf(this.myTlBlocks.size())) + "|" + this.getTextRange() + "|";
        return tlBlocksInfo + this.myOriginal.toString();
    }

    @Nullable
    public static DataLanguageBlockWrapper create(@NotNull Block original, @Nullable Indent indent) {
        if (original == null) {
            DataLanguageBlockWrapper.$$$reportNull$$$0(7);
        }
        boolean doesntNeedWrapper = original instanceof ASTBlock && ((ASTBlock)original).getNode() instanceof OuterLanguageElement;
        return doesntNeedWrapper ? null : new DataLanguageBlockWrapper(original);
    }

    @Nullable
    public ASTNode getNode() {
        return this.myOriginal instanceof ASTBlock ? ((ASTBlock)this.myOriginal).getNode() : null;
    }

    @Override
    public BlockWithParent getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(BlockWithParent parent) {
        this.myParent = parent;
    }

    public void setRightHandSpacing(DataLanguageBlockWrapper rightHandWrapper, Spacing spacing) {
        this.myRightHandWrapper = rightHandWrapper;
        this.mySpacing = spacing;
    }

    @Nullable
    public Spacing getRightHandSpacing(DataLanguageBlockWrapper rightHandWrapper) {
        return this.myRightHandWrapper == rightHandWrapper ? this.mySpacing : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/templateLanguages/DataLanguageBlockWrapper";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/templateLanguages/DataLanguageBlockWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcChildSpacing";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerChildSpacing";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

