/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.CodeStyleBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class SelectedTextFormatter {
    private final Project myProject;
    private final Editor myEditor;
    private final PsiFile myFile;
    private final String myTextBefore;
    private final RangeMarker mySelectionRangeMarker;

    public SelectedTextFormatter(Project project, Editor editor, PsiFile file2) {
        this.myProject = project;
        this.myEditor = editor;
        this.myFile = file2;
        this.myTextBefore = this.myEditor.getSelectionModel().getSelectedText();
        this.mySelectionRangeMarker = this.myEditor.getDocument().createRangeMarker(this.myEditor.getSelectionModel().getSelectionStart(), this.myEditor.getSelectionModel().getSelectionEnd());
    }

    public void restoreSelectedText() {
        Document document = this.myEditor.getDocument();
        if (!this.mySelectionRangeMarker.isValid()) {
            return;
        }
        int start2 = this.mySelectionRangeMarker.getStartOffset();
        int end = this.mySelectionRangeMarker.getEndOffset();
        WriteCommandAction.writeCommandAction((Project)this.myProject).withName(LangBundle.message((String)"command.name.configure.code.style.on.selected.fragment.restore.text.before", (Object[])new Object[0])).run(() -> document.replaceString(start2, end, (CharSequence)this.myTextBefore));
        this.myEditor.getSelectionModel().setSelection(start2, start2 + this.myTextBefore.length());
    }

    void reformatSelectedText(@NotNull CodeStyleSettings reformatSettings) {
        SelectionModel model2;
        if (reformatSettings == null) {
            SelectedTextFormatter.$$$reportNull$$$0(0);
        }
        if ((model2 = this.myEditor.getSelectionModel()).hasSelection()) {
            CodeStyle.doWithTemporarySettings((Project)this.myProject, (CodeStyleSettings)reformatSettings, () -> SelectedTextFormatter.reformatRange(this.myFile, this.getSelectedRange()));
        }
    }

    void reformatWholeFile() {
        SelectedTextFormatter.reformatRange(this.myFile, this.myFile.getTextRange());
    }

    private static void reformatRange(@NotNull PsiFile file2, @NotNull TextRange range2) {
        if (file2 == null) {
            SelectedTextFormatter.$$$reportNull$$$0(1);
        }
        if (range2 == null) {
            SelectedTextFormatter.$$$reportNull$$$0(2);
        }
        Project project = file2.getProject();
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance((Project)project).reformatText(file2, range2.getStartOffset(), range2.getEndOffset())), CodeStyleBundle.message((String)"command.name.reformat", (Object[])new Object[0]), null);
    }

    @NotNull
    TextRange getSelectedRange() {
        SelectionModel model2 = this.myEditor.getSelectionModel();
        int start2 = model2.getSelectionStart();
        int end = model2.getSelectionEnd();
        TextRange textRange = TextRange.create((int)start2, (int)end);
        if (textRange == null) {
            SelectedTextFormatter.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reformatSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/contextConfiguration/SelectedTextFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/contextConfiguration/SelectedTextFormatter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reformatSelectedText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reformatRange";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

