/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.ITNProxy;
import com.intellij.diagnostic.ITNReporterKt;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.JetBrainsAccountDialogKt;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J=\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/diagnostic/ITNReporter;", "Lcom/intellij/openapi/diagnostic/ErrorReportSubmitter;", "()V", "changeReporterAccount", "", "parentComponent", "Ljava/awt/Component;", "getPrivacyNoticeText", "", "getReportActionText", "getReporterAccount", "showErrorInRelease", "", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "submit", "events", "", "additionalInfo", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/diagnostic/SubmittedReportInfo;", "([Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;Ljava/lang/String;Ljava/awt/Component;Lcom/intellij/util/Consumer;)Z", "intellij.platform.ide.impl"})
public class ITNReporter
extends ErrorReportSubmitter {
    @NotNull
    public String getReportActionText() {
        String string = DiagnosticBundle.message("error.report.to.jetbrains.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiagnosticBundle.message\u2026ort.to.jetbrains.action\")");
        return string;
    }

    @NotNull
    public String getPrivacyNoticeText() {
        String string;
        if (CredentialAttributesKt.isFulfilled((Credentials)ErrorReportConfigurable.Companion.getCredentials())) {
            String string2 = DiagnosticBundle.message("error.dialog.notice.named", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DiagnosticBundle.message\u2026ror.dialog.notice.named\")");
        } else {
            String string3 = DiagnosticBundle.message("error.dialog.notice.anonymous", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DiagnosticBundle.message\u2026dialog.notice.anonymous\")");
        }
        return string;
    }

    @Nullable
    public String getReporterAccount() {
        Object object = ErrorReportConfigurable.Companion.getCredentials();
        if (object == null || (object = object.getUserName()) == null) {
            object = "";
        }
        return object;
    }

    public void changeReporterAccount(@NotNull Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        JetBrainsAccountDialogKt.askJBAccountCredentials$default(parentComponent, null, false, 4, null);
    }

    public boolean submit(@NotNull IdeaLoggingEvent[] events, @Nullable String additionalInfo, @NotNull Component parentComponent, @NotNull Consumer<? super SubmittedReportInfo> consumer2) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        IdeaLoggingEvent event = events[0];
        IdeaPluginDescriptor plugin2 = IdeErrorsDialog.getPlugin(event);
        String lastActionId = IdeaLogger.ourLastActionId;
        int previousReportId = -1;
        Pair previousException = ITNReporterKt.access$getPreviousReport$p();
        Object eventData = event.getData();
        if (previousException != null && eventData instanceof AbstractMessage) {
            Date date = ((AbstractMessage)eventData).getDate();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"eventData.date");
            long l = date.getTime() - ((Number)previousException.getFirst()).longValue();
            if (0L <= l && 600000L >= l) {
                previousReportId = ((Number)previousException.getSecond()).intValue();
            }
        }
        IdeaPluginDescriptor ideaPluginDescriptor = plugin2;
        IdeaPluginDescriptor ideaPluginDescriptor2 = plugin2;
        IdeaPluginDescriptor ideaPluginDescriptor3 = plugin2;
        ITNProxy.ErrorBean errorBean = new ITNProxy.ErrorBean(event, additionalInfo, ideaPluginDescriptor3 != null && (ideaPluginDescriptor3 = ideaPluginDescriptor3.getPluginId()) != null ? ideaPluginDescriptor3.getIdString() : null, ideaPluginDescriptor != null ? ideaPluginDescriptor.getName() : null, ideaPluginDescriptor2 != null ? ideaPluginDescriptor2.getVersion() : null, lastActionId, previousReportId);
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(parentComponent));
        return ITNReporterKt.access$submit(project, errorBean, parentComponent, consumer2);
    }

    public boolean showErrorInRelease(@NotNull IdeaLoggingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return false;
    }
}

