/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.ArtifactsSettings;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ProjectLibrariesSettings;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.openapi.util.JDOMUtil;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MultiFilesSettings
implements ArtifactsSettings,
ProjectLibrariesSettings {
    private final SettingsXmlFile projectFile;
    @Nullable
    private List<Path> settingsFiles;
    private final Path dir;
    private final ConversionContextImpl context;

    MultiFilesSettings(@Nullable SettingsXmlFile projectFile, @Nullable Path dir, @NotNull ConversionContextImpl context) throws CannotConvertException {
        if (context == null) {
            MultiFilesSettings.$$$reportNull$$$0(0);
        }
        if (projectFile == null && dir == null) {
            throw new IllegalArgumentException("Either project file or settings files should be not null");
        }
        this.dir = dir;
        this.context = context;
        this.projectFile = projectFile;
    }

    @NotNull
    private List<Path> getSettingsFiles() {
        if (this.settingsFiles == null) {
            this.settingsFiles = this.dir == null ? Collections.emptyList() : MultiFilesSettings.getSettingsXmlFiles(this.dir);
        }
        List<Path> list2 = this.settingsFiles;
        if (list2 == null) {
            MultiFilesSettings.$$$reportNull$$$0(1);
        }
        return list2;
    }

    /*
     * Loose catch block
     */
    @NotNull
    static List<Path> getSettingsXmlFiles(@NotNull Path dir) throws CannotConvertException {
        ArrayList<Path> arrayList;
        DirectoryStream<Path> stream;
        block13: {
            if (dir == null) {
                MultiFilesSettings.$$$reportNull$$$0(2);
            }
            stream = Files.newDirectoryStream(dir);
            ArrayList<Path> result2 = new ArrayList<Path>();
            for (Path path : stream) {
                if (!path.getFileName().toString().endsWith(".xml")) continue;
                result2.add(path);
            }
            arrayList = result2;
            if (stream == null) break block13;
            stream.close();
        }
        Object object = arrayList;
        if (object == null) {
            MultiFilesSettings.$$$reportNull$$$0(3);
        }
        return object;
        {
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException ignore) {
                    List<Path> list2 = Collections.emptyList();
                    if (list2 == null) {
                        MultiFilesSettings.$$$reportNull$$$0(4);
                    }
                    return list2;
                }
                catch (IOException e) {
                    throw new CannotConvertException(e);
                }
            }
        }
    }

    @NotNull
    private Collection<Element> getSettings(@NotNull String componentName, @NotNull String tagName) {
        if (componentName == null) {
            MultiFilesSettings.$$$reportNull$$$0(5);
        }
        if (tagName == null) {
            MultiFilesSettings.$$$reportNull$$$0(6);
        }
        ArrayList<Element> result2 = new ArrayList<Element>();
        if (this.projectFile != null) {
            result2.addAll(JDOMUtil.getChildren((Element)this.projectFile.findComponent(componentName), (String)tagName));
        }
        for (Path file2 : this.getSettingsFiles()) {
            result2.addAll(JDOMUtil.getChildren((Element)this.context.getOrCreateFile(file2).getRootElement(), (String)tagName));
        }
        ArrayList<Element> arrayList = result2;
        if (arrayList == null) {
            MultiFilesSettings.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public void collectAffectedFiles(@NotNull Collection<Path> files2) {
        if (files2 == null) {
            MultiFilesSettings.$$$reportNull$$$0(8);
        }
        if (this.projectFile != null) {
            files2.add(this.projectFile.getFile());
        }
        files2.addAll(this.getSettingsFiles());
    }

    @Override
    @NotNull
    public Collection<Element> getArtifacts() {
        return this.getSettings("ArtifactManager", "artifact");
    }

    @Override
    @NotNull
    public Collection<Element> getProjectLibraries() {
        return this.getSettings("libraryTable", "library");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/MultiFilesSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/MultiFilesSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsXmlFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsXmlFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

