/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceMatcherTerminationAspect;
import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PairedBraceMatcherAdapter
implements NontrivialBraceMatcher,
PairedBraceMatcher {
    private final PairedBraceMatcher myMatcher;
    private final Language myLanguage;

    public PairedBraceMatcherAdapter(@NotNull PairedBraceMatcher matcher, @NotNull Language language) {
        if (matcher == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(0);
        }
        if (language == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(1);
        }
        this.myMatcher = matcher;
        this.myLanguage = language;
    }

    public BracePair @NotNull [] getPairs() {
        BracePair[] bracePairArray = this.myMatcher.getPairs();
        if (bracePairArray == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(2);
        }
        return bracePairArray;
    }

    @Override
    public int getBraceTokenGroupId(@NotNull IElementType tokenType) {
        BracePair[] pairs;
        if (tokenType == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(3);
        }
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair.getLeftBraceType() && tokenType != pair.getRightBraceType()) continue;
            return this.myLanguage.hashCode();
        }
        return -1;
    }

    @Nullable
    public BracePair findPair(boolean left, HighlighterIterator iterator2, CharSequence fileText, FileType fileType) {
        BracePair[] pairs;
        IElementType tokenType = iterator2.getTokenType();
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != (left ? pair.getLeftBraceType() : pair.getRightBraceType())) continue;
            return pair;
        }
        return null;
    }

    @Override
    public boolean isLBraceToken(@NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator2 == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(4);
        }
        if (fileText == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(6);
        }
        return this.findPair(true, iterator2, fileText, fileType) != null;
    }

    @Override
    public boolean isRBraceToken(@NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator2 == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(7);
        }
        if (fileText == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(8);
        }
        if (fileType == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(9);
        }
        return this.findPair(false, iterator2, fileText, fileType) != null;
    }

    @Override
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        BracePair[] pairs;
        if (type == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(10);
        }
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (type == pair.getRightBraceType()) {
                return pair.getLeftBraceType();
            }
            if (type != pair.getLeftBraceType()) continue;
            return pair.getRightBraceType();
        }
        return null;
    }

    @Override
    public boolean isPairBraces(@NotNull IElementType tokenType, @NotNull IElementType tokenType2) {
        BracePair[] pairs;
        if (tokenType == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(11);
        }
        if (tokenType2 == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(12);
        }
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if ((tokenType != pair.getLeftBraceType() || tokenType2 != pair.getRightBraceType()) && (tokenType != pair.getRightBraceType() || tokenType2 != pair.getLeftBraceType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStructuralBrace(@NotNull HighlighterIterator iterator2, @NotNull CharSequence text2, @NotNull FileType fileType) {
        BracePair[] pairs;
        if (iterator2 == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(13);
        }
        if (text2 == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(14);
        }
        if (fileType == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(15);
        }
        IElementType tokenType = iterator2.getTokenType();
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair.getRightBraceType() && tokenType != pair.getLeftBraceType()) continue;
            return pair.isStructural();
        }
        return false;
    }

    @Override
    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(16);
        }
        return this.myMatcher.isPairedBracesAllowedBeforeType(lbraceType, contextType);
    }

    @Override
    public int getCodeConstructStart(@NotNull PsiFile file2, int openingBraceOffset) {
        if (file2 == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(17);
        }
        return this.myMatcher.getCodeConstructStart(file2, openingBraceOffset);
    }

    @Override
    @NotNull
    public List<IElementType> getOppositeBraceTokenTypes(@NotNull IElementType type) {
        if (type == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(18);
        }
        List<IElementType> result2 = null;
        for (BracePair pair : this.myMatcher.getPairs()) {
            IElementType match2 = null;
            if (type == pair.getRightBraceType()) {
                match2 = pair.getLeftBraceType();
            }
            if (type == pair.getLeftBraceType()) {
                match2 = pair.getRightBraceType();
            }
            if (match2 == null) continue;
            if (result2 == null) {
                result2 = new ArrayList<IElementType>(2);
            }
            result2.add(match2);
        }
        List<IElementType> list2 = result2 != null ? result2 : Collections.emptyList();
        if (list2 == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @Override
    public boolean shouldStopMatch(boolean forward, @NotNull IElementType braceType, @NotNull HighlighterIterator iterator2) {
        if (braceType == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(20);
        }
        if (iterator2 == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(21);
        }
        if (this.myMatcher instanceof BraceMatcherTerminationAspect) {
            return ((BraceMatcherTerminationAspect)this.myMatcher).shouldStopMatch(forward, braceType, iterator2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 4: 
            case 7: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 6: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType2";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "braceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairs";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOppositeBraceTokenTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBraceTokenGroupId";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLBraceToken";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isRBraceToken";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOppositeBraceTokenType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPairBraces";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStructuralBrace";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCodeConstructStart";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOppositeBraceTokenTypes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldStopMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

