/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorNavigationDelegate;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class EndHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public EndHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    protected void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
        int offset1;
        EditorNavigationDelegate[] extensions2;
        if (editor == null) {
            EndHandler.$$$reportNull$$$0(0);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (!settings.SMART_END_ACTION) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
        if (project == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            return;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            return;
        }
        for (EditorNavigationDelegate delegate : extensions2 = (EditorNavigationDelegate[])EditorNavigationDelegate.EP_NAME.getExtensions()) {
            if (delegate.navigateToLineEnd(editor, dataContext) != EditorNavigationDelegate.Result.STOP) continue;
            return;
        }
        CaretModel caretModel = editor.getCaretModel();
        int caretOffset = caretModel.getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        int length = editor.getDocument().getTextLength();
        if (caretOffset < length && ((offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t")) < 0 || chars.charAt(offset1) == '\n' || chars.charAt(offset1) == '\r')) {
            boolean isEmptyLine;
            int offset2 = CharArrayUtil.shiftForward((CharSequence)chars, (int)(offset1 + 1), (String)" \t");
            boolean bl = isEmptyLine = offset2 >= length || chars.charAt(offset2) == '\n' || chars.charAt(offset2) == '\r';
            if (isEmptyLine) {
                boolean stopProcessing = true;
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
                String lineIndent = styleManager.getLineIndent(file2, caretOffset);
                if (lineIndent != null) {
                    int col = EndHandler.calcColumnNumber(lineIndent, editor.getSettings().getTabSize(project));
                    int line = caretModel.getVisualPosition().line;
                    caretModel.moveToVisualPosition(new VisualPosition(line, col));
                    if (caretModel.getLogicalPosition().column != col) {
                        if (!ApplicationManager.getApplication().isWriteAccessAllowed() && !FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
                            return;
                        }
                        editor.getSelectionModel().removeSelection();
                        WriteAction.run(() -> document.replaceString(offset1 + 1, offset2, (CharSequence)lineIndent));
                    }
                } else {
                    stopProcessing = false;
                }
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().removeSelection();
                if (stopProcessing) {
                    return;
                }
            }
        }
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }

    private static int calcColumnNumber(String lineIndent, int tabSize) {
        int result2 = 0;
        for (char c : lineIndent.toCharArray()) {
            if (c == ' ') {
                ++result2;
            }
            if (c != '\t') continue;
            result2 += tabSize;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/EndHandler", "doExecute"));
    }
}

