/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightingSettingProvider;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OutsidersPsiFileSupport {
    private static final Key<Boolean> KEY = Key.create((String)"OutsidersPsiFileSupport");
    private static final Key<String> FILE_PATH_KEY = Key.create((String)"OutsidersPsiFileSupport.FilePath");

    public static void markFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            OutsidersPsiFileSupport.$$$reportNull$$$0(0);
        }
        OutsidersPsiFileSupport.markFile(file2, null);
    }

    public static void markFile(@NotNull VirtualFile file2, @Nullable String originalPath) {
        if (file2 == null) {
            OutsidersPsiFileSupport.$$$reportNull$$$0(1);
        }
        file2.putUserData(KEY, (Object)Boolean.TRUE);
        if (originalPath != null) {
            file2.putUserData(FILE_PATH_KEY, (Object)FileUtil.toSystemIndependentName((String)originalPath));
        }
    }

    public static boolean isOutsiderFile(@Nullable PsiFile file2) {
        return file2 != null && OutsidersPsiFileSupport.isOutsiderFile(file2.getVirtualFile());
    }

    public static boolean isOutsiderFile(@Nullable VirtualFile file2) {
        return file2 != null && file2.getUserData(KEY) == Boolean.TRUE;
    }

    @Nullable
    public static String getOriginalFilePath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            OutsidersPsiFileSupport.$$$reportNull$$$0(2);
        }
        return (String)file2.getUserData(FILE_PATH_KEY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/codeInsight/daemon/OutsidersPsiFileSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOriginalFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class HighlightingSettingProvider
    extends DefaultHighlightingSettingProvider {
        @Nullable
        public FileHighlightingSetting getDefaultSetting(@NotNull Project project, @NotNull VirtualFile file2) {
            if (project == null) {
                HighlightingSettingProvider.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                HighlightingSettingProvider.$$$reportNull$$$0(1);
            }
            if (!OutsidersPsiFileSupport.isOutsiderFile(file2)) {
                return null;
            }
            return FileHighlightingSetting.SKIP_INSPECTION;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/OutsidersPsiFileSupport$HighlightingSettingProvider";
            objectArray[2] = "getDefaultSetting";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class IntentionFilter
    implements IntentionActionFilter {
        @Override
        public boolean accept(@NotNull IntentionAction intentionAction, @Nullable PsiFile file2) {
            if (intentionAction == null) {
                IntentionFilter.$$$reportNull$$$0(0);
            }
            return !OutsidersPsiFileSupport.isOutsiderFile(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/codeInsight/daemon/OutsidersPsiFileSupport$IntentionFilter", "accept"));
        }
    }

    public static class HighlightFilter
    implements HighlightInfoFilter {
        @Override
        public boolean accept(@NotNull HighlightInfo info, @Nullable PsiFile file2) {
            if (info == null) {
                HighlightFilter.$$$reportNull$$$0(0);
            }
            if (!OutsidersPsiFileSupport.isOutsiderFile(file2)) {
                return true;
            }
            return info.getSeverity() != HighlightSeverity.ERROR;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/OutsidersPsiFileSupport$HighlightFilter", "accept"));
        }
    }
}

