/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.actions.CodeInsightEditorAction;
import com.intellij.codeInsight.actions.MultiCaretCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public abstract class MultiCaretCodeInsightAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(MultiCaretCodeInsightAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Editor hostEditor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (hostEditor == null) {
            return;
        }
        if (hostEditor.isDisposed()) {
            LOG.error("Action " + this + " invoked on a disposed editor in " + e.getDataContext());
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)hostEditor)) {
            return;
        }
        PsiFile hostFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(hostEditor.getDocument());
        if (hostFile != null && !FileModificationService.getInstance().prepareFileForWrite(hostFile)) {
            return;
        }
        this.actionPerformedImpl(project, hostEditor);
    }

    public void actionPerformedImpl(Project project, Editor hostEditor) {
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            MultiCaretCodeInsightActionHandler handler2 = this.getHandler();
            try {
                MultiCaretCodeInsightAction.iterateOverCarets(project, hostEditor, handler2);
            }
            finally {
                handler2.postInvoke();
            }
        }), this.getCommandName(), (Object)DocCommandGroupId.noneGroupId((Document)hostEditor.getDocument()));
        hostEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(1);
        }
        CodeInsightEditorAction.beforeActionPerformedUpdate((AnActionEvent)e);
        super.beforeActionPerformedUpdate(e);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation2.setEnabled(false);
            return;
        }
        Editor hostEditor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (hostEditor == null) {
            presentation2.setEnabled(false);
            return;
        }
        if (hostEditor.isDisposed()) {
            LOG.error("Disposed editor in " + e.getDataContext() + " for " + this);
            presentation2.setEnabled(false);
            return;
        }
        final Ref enabled = new Ref((Object)Boolean.FALSE);
        MultiCaretCodeInsightAction.iterateOverCarets(project, hostEditor, new MultiCaretCodeInsightActionHandler(){

            @Override
            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file2) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (caret == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (MultiCaretCodeInsightAction.this.isValidFor(project, editor, caret, file2)) {
                    enabled.set((Object)Boolean.TRUE);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "caret";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        presentation2.setEnabled(((Boolean)enabled.get()).booleanValue());
    }

    private static void iterateOverCarets(@NotNull Project project, @NotNull Editor hostEditor, @NotNull MultiCaretCodeInsightActionHandler handler2) {
        if (project == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(3);
        }
        if (hostEditor == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(4);
        }
        if (handler2 == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(5);
        }
        PsiFile hostFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(hostEditor.getDocument());
        hostEditor.getCaretModel().runForEachCaret(caret -> {
            PsiFile file2;
            Caret injectedCaret;
            Editor editor = hostEditor;
            if (hostFile != null && (injectedCaret = InjectedLanguageUtil.getCaretForInjectedLanguageNoCommit(caret, hostFile)) != null) {
                caret = injectedCaret;
                editor = caret.getEditor();
            }
            if ((file2 = PsiUtilBase.getPsiFileInEditor((Caret)caret, (Project)project)) != null) {
                handler2.invoke(project, editor, caret, file2);
            }
        });
    }

    protected boolean isValidFor(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file2) {
        if (project == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(7);
        }
        if (caret == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            MultiCaretCodeInsightAction.$$$reportNull$$$0(9);
        }
        return true;
    }

    @NotNull
    protected abstract MultiCaretCodeInsightActionHandler getHandler();

    @NlsContexts.Command
    protected String getCommandName() {
        String text2 = this.getTemplatePresentation().getText();
        return text2 == null ? "" : text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateOverCarets";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

