/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.accessibility;

import com.intellij.accessibility.AccessibilityUsageTrackerCollector;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.User32Ex;
import com.sun.jna.platform.win32.WinDef;
import javax.swing.Icon;

public final class AccessibilityUtils {
    public static void enableScreenReaderSupportIfNecessary() {
        if (GeneralSettings.isSupportScreenReadersOverridden()) {
            AccessibilityUsageTrackerCollector.featureTriggered(AccessibilityUsageTrackerCollector.SCREEN_READER_SUPPORT_ENABLED_VM);
            return;
        }
        if (AccessibilityUtils.isScreenReaderDetected()) {
            AccessibilityUsageTrackerCollector.featureTriggered(AccessibilityUsageTrackerCollector.SCREEN_READER_DETECTED);
            String appName = ApplicationInfoImpl.getShadowInstance().getVersionName();
            int answer = Messages.showYesNoDialog((String)ApplicationBundle.message((String)"confirmation.screen.reader.enable", (Object[])new Object[]{appName}), (String)ApplicationBundle.message((String)"title.screen.reader.support", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"button.enable", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                AccessibilityUsageTrackerCollector.featureTriggered(AccessibilityUsageTrackerCollector.SCREEN_READER_SUPPORT_ENABLED);
                System.setProperty("ide.support.screenreaders.detected", "true");
            }
        }
    }

    public static boolean isScreenReaderDetected() {
        if (SystemInfoRt.isWindows) {
            return AccessibilityUtils.isWindowsScreenReaderEnabled();
        }
        if (SystemInfoRt.isMac) {
            return AccessibilityUtils.isMacVoiceOverEnabled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMacVoiceOverEnabled() {
        boolean bl;
        Foundation.NSAutoreleasePool pool;
        block3: {
            pool = new Foundation.NSAutoreleasePool();
            ID universalAccess = null;
            try {
                universalAccess = Foundation.invoke((ID)Foundation.invoke((String)"NSUserDefaults", (String)"alloc", (Object[])new Object[0]), (String)"initWithSuiteName:", (Object[])new Object[]{Foundation.nsString((String)"com.apple.universalaccess")});
                ID voiceOverEnabledKey = Foundation.invoke((ID)universalAccess, (String)"boolForKey:", (Object[])new Object[]{Foundation.nsString((String)"voiceOverOnOffKey")});
                bl = voiceOverEnabledKey.booleanValue();
                if (universalAccess == null) break block3;
            }
            catch (Throwable throwable) {
                if (universalAccess != null) {
                    Foundation.cfRelease((ID[])new ID[]{universalAccess});
                }
                pool.drain();
                throw throwable;
            }
            Foundation.cfRelease((ID[])new ID[]{universalAccess});
        }
        pool.drain();
        return bl;
    }

    private static boolean isWindowsScreenReaderEnabled() {
        WinDef.BOOLByReference isActive = new WinDef.BOOLByReference();
        boolean retValue = User32Ex.INSTANCE.SystemParametersInfo(new WinDef.UINT(70L), new WinDef.UINT(0L), isActive, new WinDef.UINT(0L));
        return retValue && isActive.getValue().booleanValue();
    }
}

