/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util.classFinder;

import java.io.InputStream;

public class ClassEntry {
    private final String myClassName;
    private final ClassLoader myClassLoader;

    public ClassEntry(String className, ClassLoader classLoader) {
        this.myClassName = className;
        this.myClassLoader = classLoader;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public InputStream getClassInputStream() {
        String resourceName = this.myClassName.replace('.', '/') + ".class";
        InputStream is = this.getResourceStream(resourceName);
        if (is != null) {
            return is;
        }
        return this.getResourceStream("/" + resourceName);
    }

    private InputStream getResourceStream(String resourceName) {
        if (this.myClassLoader == null) {
            return this.getClass().getResourceAsStream(resourceName);
        }
        return this.myClassLoader.getResourceAsStream(resourceName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassEntry that = (ClassEntry)o;
        if (this.myClassLoader != null ? !this.myClassLoader.equals(that.myClassLoader) : that.myClassLoader != null) {
            return false;
        }
        return this.myClassName.equals(that.myClassName);
    }

    public int hashCode() {
        int result = this.myClassName.hashCode();
        result = 31 * result + (this.myClassLoader != null ? this.myClassLoader.hashCode() : 0);
        return result;
    }
}

