/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

abstract class DefaultConstructorDetectionVisitor
extends MethodVisitor {
    private boolean isDefault = true;

    DefaultConstructorDetectionVisitor(int api, MethodVisitor mv) {
        super(api, mv);
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (opcode == 177) {
            return;
        }
        if (this.isDefault) {
            this.isDefault = false;
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        if (this.isDefault) {
            this.isDefault = false;
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        if (opcode == 183 && "<init>".equals(name) && "()V".equals(desc) && !itf) {
            return;
        }
        if (this.isDefault) {
            this.isDefault = false;
        }
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        if (opcode == 25 && var == 0) {
            return;
        }
        if (this.isDefault) {
            this.isDefault = false;
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        if (this.isDefault) {
            this.isDefault = false;
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        if (this.isDefault) {
            this.isDefault = false;
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (this.isDefault) {
            this.isDefault = false;
        }
    }

    public void visitEnd() {
        super.visitEnd();
        this.onDecisionDone(this.isDefault);
    }

    abstract void onDecisionDone(boolean var1);
}

