/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Debug;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.jf.baksmali.Adaptors.Debug.DebugMethodItem;
import org.jf.baksmali.Adaptors.Debug.LocalFormatter;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.dexlib2.iface.debug.RestartLocal;
import org.jf.util.IndentingWriter;

public class RestartLocalMethodItem
extends DebugMethodItem {
    @Nonnull
    private final RestartLocal restartLocal;
    @Nonnull
    private final RegisterFormatter registerFormatter;

    public RestartLocalMethodItem(int codeAddress, int sortOrder, @Nonnull RegisterFormatter registerFormatter, @Nonnull RestartLocal restartLocal) {
        super(codeAddress, sortOrder);
        this.restartLocal = restartLocal;
        this.registerFormatter = registerFormatter;
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        writer.write(".restart local ");
        this.registerFormatter.writeTo(writer, this.restartLocal.getRegister());
        String name = this.restartLocal.getName();
        String type = this.restartLocal.getType();
        String signature = this.restartLocal.getSignature();
        if (name != null || type != null || signature != null) {
            writer.write("    # ");
            LocalFormatter.writeLocal(writer, name, type, signature);
        }
        return true;
    }
}

