/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallCheckerKt;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedOperatorMod;", "Lorg/jetbrains/kotlin/resolve/deprecation/Deprecation;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "currentDeprecation", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/deprecation/Deprecation;)V", "getCurrentDeprecation", "()Lorg/jetbrains/kotlin/resolve/deprecation/Deprecation;", "deprecationLevel", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "getDeprecationLevel", "()Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "message", "", "getMessage", "()Ljava/lang/String;", "target", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getTarget", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "frontend"})
public final class DeprecatedOperatorMod
implements Deprecation {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final Deprecation currentDeprecation;

    @Override
    @NotNull
    public DeprecationLevelValue getDeprecationLevel() {
        ApiVersion apiVersion = this.languageVersionSettings.getApiVersion();
        return Intrinsics.areEqual(apiVersion, ApiVersion.KOTLIN_1_1) || Intrinsics.areEqual(apiVersion, ApiVersion.KOTLIN_1_2) ? DeprecationLevelValue.WARNING : (Intrinsics.areEqual(apiVersion, ApiVersion.KOTLIN_1_3) ? DeprecationLevelValue.ERROR : DeprecationLevelValue.ERROR);
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.currentDeprecation.getMessage();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getTarget() {
        return this.currentDeprecation.getTarget();
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final Deprecation getCurrentDeprecation() {
        return this.currentDeprecation;
    }

    public DeprecatedOperatorMod(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull Deprecation currentDeprecation) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(currentDeprecation, "currentDeprecation");
        this.languageVersionSettings = languageVersionSettings;
        this.currentDeprecation = currentDeprecation;
        boolean bl = OperatorCallCheckerKt.shouldWarnAboutDeprecatedModFromBuiltIns(this.languageVersionSettings);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Deprecation created for mod that shouldn't have any deprecations; languageVersionSettings: " + this.languageVersionSettings;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }

    @Override
    public boolean getPropagatesToOverrides() {
        return Deprecation.DefaultImpls.getPropagatesToOverrides(this);
    }

    @NotNull
    public final LanguageVersionSettings component1() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final Deprecation component2() {
        return this.currentDeprecation;
    }

    @NotNull
    public final DeprecatedOperatorMod copy(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull Deprecation currentDeprecation) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(currentDeprecation, "currentDeprecation");
        return new DeprecatedOperatorMod(languageVersionSettings, currentDeprecation);
    }

    public static /* synthetic */ DeprecatedOperatorMod copy$default(DeprecatedOperatorMod deprecatedOperatorMod, LanguageVersionSettings languageVersionSettings, Deprecation deprecation, int n, Object object) {
        if ((n & 1) != 0) {
            languageVersionSettings = deprecatedOperatorMod.languageVersionSettings;
        }
        if ((n & 2) != 0) {
            deprecation = deprecatedOperatorMod.currentDeprecation;
        }
        return deprecatedOperatorMod.copy(languageVersionSettings, deprecation);
    }

    @NotNull
    public String toString() {
        return "DeprecatedOperatorMod(languageVersionSettings=" + this.languageVersionSettings + ", currentDeprecation=" + this.currentDeprecation + ")";
    }

    public int hashCode() {
        LanguageVersionSettings languageVersionSettings = this.languageVersionSettings;
        Deprecation deprecation = this.currentDeprecation;
        return (languageVersionSettings != null ? languageVersionSettings.hashCode() : 0) * 31 + (deprecation != null ? deprecation.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DeprecatedOperatorMod)) break block3;
                DeprecatedOperatorMod deprecatedOperatorMod = (DeprecatedOperatorMod)object;
                if (!Intrinsics.areEqual(this.languageVersionSettings, deprecatedOperatorMod.languageVersionSettings) || !Intrinsics.areEqual(this.currentDeprecation, deprecatedOperatorMod.currentDeprecation)) break block3;
            }
            return true;
        }
        return false;
    }
}

